/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.multi.MultipleBarcodeReader;
import java.util.Hashtable;
import java.util.Vector;

public final class GenericMultipleBarcodeReader
implements MultipleBarcodeReader {
    private static final int MIN_DIMENSION_TO_RECUR = 100;
    private final Reader delegate;

    public GenericMultipleBarcodeReader(Reader delegate) {
        this.delegate = delegate;
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap image) throws NotFoundException {
        return this.decodeMultiple(image, null);
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap image, Hashtable hints) throws NotFoundException {
        Vector results = new Vector();
        this.doDecodeMultiple(image, hints, results, 0, 0);
        if (results.isEmpty()) {
            throw NotFoundException.getNotFoundInstance();
        }
        int numResults = results.size();
        Result[] resultArray = new Result[numResults];
        int i = 0;
        while (i < numResults) {
            resultArray[i] = (Result)results.elementAt(i);
            ++i;
        }
        return resultArray;
    }

    private void doDecodeMultiple(BinaryBitmap image, Hashtable hints, Vector results, int xOffset, int yOffset) {
        Result result;
        try {
            result = this.delegate.decode(image, hints);
        }
        catch (ReaderException re) {
            return;
        }
        boolean alreadyFound = false;
        int i = 0;
        while (i < results.size()) {
            Result existingResult = (Result)results.elementAt(i);
            if (existingResult.getText().equals(result.getText())) {
                alreadyFound = true;
                break;
            }
            ++i;
        }
        if (alreadyFound) {
            return;
        }
        results.addElement(GenericMultipleBarcodeReader.translateResultPoints(result, xOffset, yOffset));
        ResultPoint[] resultPoints = result.getResultPoints();
        if (resultPoints == null || resultPoints.length == 0) {
            return;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        float minX = width;
        float minY = height;
        float maxX = 0.0f;
        float maxY = 0.0f;
        int i2 = 0;
        while (i2 < resultPoints.length) {
            ResultPoint point = resultPoints[i2];
            float x = point.getX();
            float y = point.getY();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            ++i2;
        }
        if (minX > 100.0f) {
            this.doDecodeMultiple(image.crop(0, 0, (int)minX, height), hints, results, xOffset, yOffset);
        }
        if (minY > 100.0f) {
            this.doDecodeMultiple(image.crop(0, 0, width, (int)minY), hints, results, xOffset, yOffset);
        }
        if (maxX < (float)(width - 100)) {
            this.doDecodeMultiple(image.crop((int)maxX, 0, width - (int)maxX, height), hints, results, xOffset + (int)maxX, yOffset);
        }
        if (maxY < (float)(height - 100)) {
            this.doDecodeMultiple(image.crop(0, (int)maxY, width, height - (int)maxY), hints, results, xOffset, yOffset + (int)maxY);
        }
    }

    private static Result translateResultPoints(Result result, int xOffset, int yOffset) {
        ResultPoint[] oldResultPoints = result.getResultPoints();
        ResultPoint[] newResultPoints = new ResultPoint[oldResultPoints.length];
        int i = 0;
        while (i < oldResultPoints.length) {
            ResultPoint oldPoint = oldResultPoints[i];
            newResultPoints[i] = new ResultPoint(oldPoint.getX() + (float)xOffset, oldPoint.getY() + (float)yOffset);
            ++i;
        }
        return new Result(result.getText(), result.getRawBytes(), newResultPoints, result.getBarcodeFormat());
    }
}

