/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.decoder;

import com.google.zxing.datamatrix.decoder.Version;

final class DataBlock {
    private final int numDataCodewords;
    private final byte[] codewords;

    private DataBlock(int numDataCodewords, byte[] codewords) {
        this.numDataCodewords = numDataCodewords;
        this.codewords = codewords;
    }

    static DataBlock[] getDataBlocks(byte[] rawCodewords, Version version) {
        Version.ECBlocks ecBlocks = version.getECBlocks();
        int totalBlocks = 0;
        Version.ECB[] ecBlockArray = ecBlocks.getECBlocks();
        int i = 0;
        while (i < ecBlockArray.length) {
            totalBlocks += ecBlockArray[i].getCount();
            ++i;
        }
        DataBlock[] result = new DataBlock[totalBlocks];
        int numResultBlocks = 0;
        int j = 0;
        while (j < ecBlockArray.length) {
            Version.ECB ecBlock = ecBlockArray[j];
            int i2 = 0;
            while (i2 < ecBlock.getCount()) {
                int numDataCodewords = ecBlock.getDataCodewords();
                int numBlockCodewords = ecBlocks.getECCodewords() + numDataCodewords;
                result[numResultBlocks++] = new DataBlock(numDataCodewords, new byte[numBlockCodewords]);
                ++i2;
            }
            ++j;
        }
        int longerBlocksTotalCodewords = result[0].codewords.length;
        int longerBlocksNumDataCodewords = longerBlocksTotalCodewords - ecBlocks.getECCodewords();
        int shorterBlocksNumDataCodewords = longerBlocksNumDataCodewords - 1;
        int rawCodewordsOffset = 0;
        int i3 = 0;
        while (i3 < shorterBlocksNumDataCodewords) {
            int j2 = 0;
            while (j2 < numResultBlocks) {
                result[j2].codewords[i3] = rawCodewords[rawCodewordsOffset++];
                ++j2;
            }
            ++i3;
        }
        boolean specialVersion = version.getVersionNumber() == 24;
        int numLongerBlocks = specialVersion ? 8 : numResultBlocks;
        int j3 = 0;
        while (j3 < numLongerBlocks) {
            result[j3].codewords[longerBlocksNumDataCodewords - 1] = rawCodewords[rawCodewordsOffset++];
            ++j3;
        }
        int max = result[0].codewords.length;
        int i4 = longerBlocksNumDataCodewords;
        while (i4 < max) {
            int j4 = 0;
            while (j4 < numResultBlocks) {
                int iOffset = specialVersion && j4 > 7 ? i4 - 1 : i4;
                result[j4].codewords[iOffset] = rawCodewords[rawCodewordsOffset++];
                ++j4;
            }
            ++i4;
        }
        if (rawCodewordsOffset != rawCodewords.length) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    int getNumDataCodewords() {
        return this.numDataCodewords;
    }

    byte[] getCodewords() {
        return this.codewords;
    }
}

