/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.reedsolomon;

import com.google.zxing.common.reedsolomon.GF256;

final class GF256Poly {
    private final GF256 field;
    private final int[] coefficients;

    GF256Poly(GF256 field, int[] coefficients) {
        if (coefficients == null || coefficients.length == 0) {
            throw new IllegalArgumentException();
        }
        this.field = field;
        int coefficientsLength = coefficients.length;
        if (coefficientsLength > 1 && coefficients[0] == 0) {
            int firstNonZero = 1;
            while (firstNonZero < coefficientsLength && coefficients[firstNonZero] == 0) {
                ++firstNonZero;
            }
            if (firstNonZero == coefficientsLength) {
                this.coefficients = field.getZero().coefficients;
            } else {
                this.coefficients = new int[coefficientsLength - firstNonZero];
                System.arraycopy(coefficients, firstNonZero, this.coefficients, 0, this.coefficients.length);
            }
        } else {
            this.coefficients = coefficients;
        }
    }

    int[] getCoefficients() {
        return this.coefficients;
    }

    int getDegree() {
        return this.coefficients.length - 1;
    }

    boolean isZero() {
        return this.coefficients[0] == 0;
    }

    int getCoefficient(int degree) {
        return this.coefficients[this.coefficients.length - 1 - degree];
    }

    int evaluateAt(int a) {
        if (a == 0) {
            return this.getCoefficient(0);
        }
        int size = this.coefficients.length;
        if (a == 1) {
            int result = 0;
            int i = 0;
            while (i < size) {
                result = GF256.addOrSubtract(result, this.coefficients[i]);
                ++i;
            }
            return result;
        }
        int result = this.coefficients[0];
        int i = 1;
        while (i < size) {
            result = GF256.addOrSubtract(this.field.multiply(a, result), this.coefficients[i]);
            ++i;
        }
        return result;
    }

    GF256Poly addOrSubtract(GF256Poly other) {
        if (!this.field.equals(other.field)) {
            throw new IllegalArgumentException("GF256Polys do not have same GF256 field");
        }
        if (this.isZero()) {
            return other;
        }
        if (other.isZero()) {
            return this;
        }
        int[] smallerCoefficients = this.coefficients;
        int[] largerCoefficients = other.coefficients;
        if (smallerCoefficients.length > largerCoefficients.length) {
            int[] temp = smallerCoefficients;
            smallerCoefficients = largerCoefficients;
            largerCoefficients = temp;
        }
        int[] sumDiff = new int[largerCoefficients.length];
        int lengthDiff = largerCoefficients.length - smallerCoefficients.length;
        System.arraycopy(largerCoefficients, 0, sumDiff, 0, lengthDiff);
        int i = lengthDiff;
        while (i < largerCoefficients.length) {
            sumDiff[i] = GF256.addOrSubtract(smallerCoefficients[i - lengthDiff], largerCoefficients[i]);
            ++i;
        }
        return new GF256Poly(this.field, sumDiff);
    }

    GF256Poly multiply(GF256Poly other) {
        if (!this.field.equals(other.field)) {
            throw new IllegalArgumentException("GF256Polys do not have same GF256 field");
        }
        if (this.isZero() || other.isZero()) {
            return this.field.getZero();
        }
        int[] aCoefficients = this.coefficients;
        int aLength = aCoefficients.length;
        int[] bCoefficients = other.coefficients;
        int bLength = bCoefficients.length;
        int[] product = new int[aLength + bLength - 1];
        int i = 0;
        while (i < aLength) {
            int aCoeff = aCoefficients[i];
            int j = 0;
            while (j < bLength) {
                product[i + j] = GF256.addOrSubtract(product[i + j], this.field.multiply(aCoeff, bCoefficients[j]));
                ++j;
            }
            ++i;
        }
        return new GF256Poly(this.field, product);
    }

    GF256Poly multiply(int scalar) {
        if (scalar == 0) {
            return this.field.getZero();
        }
        if (scalar == 1) {
            return this;
        }
        int size = this.coefficients.length;
        int[] product = new int[size];
        int i = 0;
        while (i < size) {
            product[i] = this.field.multiply(this.coefficients[i], scalar);
            ++i;
        }
        return new GF256Poly(this.field, product);
    }

    GF256Poly multiplyByMonomial(int degree, int coefficient) {
        if (degree < 0) {
            throw new IllegalArgumentException();
        }
        if (coefficient == 0) {
            return this.field.getZero();
        }
        int size = this.coefficients.length;
        int[] product = new int[size + degree];
        int i = 0;
        while (i < size) {
            product[i] = this.field.multiply(this.coefficients[i], coefficient);
            ++i;
        }
        return new GF256Poly(this.field, product);
    }

    GF256Poly[] divide(GF256Poly other) {
        if (!this.field.equals(other.field)) {
            throw new IllegalArgumentException("GF256Polys do not have same GF256 field");
        }
        if (other.isZero()) {
            throw new IllegalArgumentException("Divide by 0");
        }
        GF256Poly quotient = this.field.getZero();
        GF256Poly remainder = this;
        int denominatorLeadingTerm = other.getCoefficient(other.getDegree());
        int inverseDenominatorLeadingTerm = this.field.inverse(denominatorLeadingTerm);
        while (remainder.getDegree() >= other.getDegree() && !remainder.isZero()) {
            int degreeDifference = remainder.getDegree() - other.getDegree();
            int scale = this.field.multiply(remainder.getCoefficient(remainder.getDegree()), inverseDenominatorLeadingTerm);
            GF256Poly term = other.multiplyByMonomial(degreeDifference, scale);
            GF256Poly iterationQuotient = this.field.buildMonomial(degreeDifference, scale);
            quotient = quotient.addOrSubtract(iterationQuotient);
            remainder = remainder.addOrSubtract(term);
        }
        return new GF256Poly[]{quotient, remainder};
    }

    public String toString() {
        StringBuffer result = new StringBuffer(8 * this.getDegree());
        int degree = this.getDegree();
        while (degree >= 0) {
            int coefficient = this.getCoefficient(degree);
            if (coefficient != 0) {
                if (coefficient < 0) {
                    result.append(" - ");
                    coefficient = -coefficient;
                } else if (result.length() > 0) {
                    result.append(" + ");
                }
                if (degree == 0 || coefficient != 1) {
                    int alphaPower = this.field.log(coefficient);
                    if (alphaPower == 0) {
                        result.append('1');
                    } else if (alphaPower == 1) {
                        result.append('a');
                    } else {
                        result.append("a^");
                        result.append(alphaPower);
                    }
                }
                if (degree != 0) {
                    if (degree == 1) {
                        result.append('x');
                    } else {
                        result.append("x^");
                        result.append(degree);
                    }
                }
            }
            --degree;
        }
        return result.toString();
    }
}

