/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AddressBookParsedResult;
import com.google.zxing.client.result.ResultParser;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

final class VCardResultParser
extends ResultParser {
    private VCardResultParser() {
    }

    public static AddressBookParsedResult parse(Result result) {
        String rawText = result.getText();
        if (rawText == null || !rawText.startsWith("BEGIN:VCARD")) {
            return null;
        }
        String[] names = VCardResultParser.matchVCardPrefixedField("FN", rawText, true);
        if (names == null) {
            names = VCardResultParser.matchVCardPrefixedField("N", rawText, true);
            VCardResultParser.formatNames(names);
        }
        String[] phoneNumbers = VCardResultParser.matchVCardPrefixedField("TEL", rawText, true);
        String[] emails = VCardResultParser.matchVCardPrefixedField("EMAIL", rawText, true);
        String note = VCardResultParser.matchSingleVCardPrefixedField("NOTE", rawText, false);
        String[] addresses = VCardResultParser.matchVCardPrefixedField("ADR", rawText, true);
        if (addresses != null) {
            int i = 0;
            while (i < addresses.length) {
                addresses[i] = VCardResultParser.formatAddress(addresses[i]);
                ++i;
            }
        }
        String org = VCardResultParser.matchSingleVCardPrefixedField("ORG", rawText, true);
        String birthday = VCardResultParser.matchSingleVCardPrefixedField("BDAY", rawText, true);
        if (!VCardResultParser.isLikeVCardDate(birthday)) {
            birthday = null;
        }
        String title = VCardResultParser.matchSingleVCardPrefixedField("TITLE", rawText, true);
        String url = VCardResultParser.matchSingleVCardPrefixedField("URL", rawText, true);
        return new AddressBookParsedResult(names, null, phoneNumbers, emails, note, addresses, org, birthday, title, url);
    }

    private static String[] matchVCardPrefixedField(String prefix, String rawText, boolean trim) {
        Vector<String> matches = null;
        int i = 0;
        int max = rawText.length();
        while (i < max) {
            if ((i = rawText.indexOf(prefix, i)) < 0) break;
            if (i > 0 && rawText.charAt(i - 1) != '\n') {
                ++i;
                continue;
            }
            if (rawText.charAt(i += prefix.length()) != ':' && rawText.charAt(i) != ';') continue;
            int metadataStart = i;
            while (rawText.charAt(i) != ':') {
                ++i;
            }
            boolean quotedPrintable = false;
            String quotedPrintableCharset = null;
            if (i > metadataStart) {
                int j = metadataStart + 1;
                while (j <= i) {
                    if (rawText.charAt(j) == ';' || rawText.charAt(j) == ':') {
                        String metadata = rawText.substring(metadataStart + 1, j);
                        int equals = metadata.indexOf(61);
                        if (equals >= 0) {
                            String key = metadata.substring(0, equals);
                            String value = metadata.substring(equals + 1);
                            if (key.equalsIgnoreCase("ENCODING")) {
                                if (value.equalsIgnoreCase("QUOTED-PRINTABLE")) {
                                    quotedPrintable = true;
                                }
                            } else if (key.equalsIgnoreCase("CHARSET")) {
                                quotedPrintableCharset = value;
                            }
                        }
                        metadataStart = j;
                    }
                    ++j;
                }
            }
            int matchStart = ++i;
            while ((i = rawText.indexOf(10, i)) >= 0) {
                if (i < rawText.length() - 1 && (rawText.charAt(i + 1) == ' ' || rawText.charAt(i + 1) == '\t')) {
                    i += 2;
                    continue;
                }
                if (!quotedPrintable || rawText.charAt(i - 1) != '=' && rawText.charAt(i - 2) != '=') break;
                ++i;
            }
            if (i < 0) {
                i = max;
                continue;
            }
            if (i > matchStart) {
                if (matches == null) {
                    matches = new Vector<String>(1);
                }
                if (rawText.charAt(i - 1) == '\r') {
                    --i;
                }
                String element = rawText.substring(matchStart, i);
                if (trim) {
                    element = element.trim();
                }
                element = quotedPrintable ? VCardResultParser.decodeQuotedPrintable(element, quotedPrintableCharset) : VCardResultParser.stripContinuationCRLF(element);
                matches.addElement(element);
                ++i;
                continue;
            }
            ++i;
        }
        if (matches == null || matches.isEmpty()) {
            return null;
        }
        return VCardResultParser.toStringArray(matches);
    }

    private static String stripContinuationCRLF(String value) {
        int length = value.length();
        StringBuffer result = new StringBuffer(length);
        boolean lastWasLF = false;
        int i = 0;
        while (i < length) {
            if (lastWasLF) {
                lastWasLF = false;
            } else {
                char c = value.charAt(i);
                lastWasLF = false;
                switch (c) {
                    case '\n': {
                        lastWasLF = true;
                        break;
                    }
                    case '\r': {
                        break;
                    }
                    default: {
                        result.append(c);
                    }
                }
            }
            ++i;
        }
        return result.toString();
    }

    private static String decodeQuotedPrintable(String value, String charset) {
        int length = value.length();
        StringBuffer result = new StringBuffer(length);
        ByteArrayOutputStream fragmentBuffer = new ByteArrayOutputStream();
        int i = 0;
        while (i < length) {
            char c = value.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    break;
                }
                case '=': {
                    char nextChar;
                    if (i >= length - 2 || (nextChar = value.charAt(i + 1)) == '\r' || nextChar == '\n') break;
                    char nextNextChar = value.charAt(i + 2);
                    try {
                        int encodedByte = 16 * VCardResultParser.toHexValue(nextChar) + VCardResultParser.toHexValue(nextNextChar);
                        fragmentBuffer.write(encodedByte);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    i += 2;
                    break;
                }
                default: {
                    VCardResultParser.maybeAppendFragment(fragmentBuffer, charset, result);
                    result.append(c);
                }
            }
            ++i;
        }
        VCardResultParser.maybeAppendFragment(fragmentBuffer, charset, result);
        return result.toString();
    }

    private static int toHexValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException();
    }

    private static void maybeAppendFragment(ByteArrayOutputStream fragmentBuffer, String charset, StringBuffer result) {
        if (fragmentBuffer.size() > 0) {
            String fragment;
            byte[] fragmentBytes = fragmentBuffer.toByteArray();
            if (charset == null) {
                fragment = new String(fragmentBytes);
            } else {
                try {
                    fragment = new String(fragmentBytes, charset);
                }
                catch (UnsupportedEncodingException e) {
                    fragment = new String(fragmentBytes);
                }
            }
            fragmentBuffer.reset();
            result.append(fragment);
        }
    }

    static String matchSingleVCardPrefixedField(String prefix, String rawText, boolean trim) {
        String[] values = VCardResultParser.matchVCardPrefixedField(prefix, rawText, trim);
        return values == null ? null : values[0];
    }

    private static boolean isLikeVCardDate(String value) {
        if (value == null) {
            return true;
        }
        if (VCardResultParser.isStringOfDigits(value, 8)) {
            return true;
        }
        return value.length() == 10 && value.charAt(4) == '-' && value.charAt(7) == '-' && VCardResultParser.isSubstringOfDigits(value, 0, 4) && VCardResultParser.isSubstringOfDigits(value, 5, 2) && VCardResultParser.isSubstringOfDigits(value, 8, 2);
    }

    private static String formatAddress(String address) {
        if (address == null) {
            return null;
        }
        int length = address.length();
        StringBuffer newAddress = new StringBuffer(length);
        int j = 0;
        while (j < length) {
            char c = address.charAt(j);
            if (c == ';') {
                newAddress.append(' ');
            } else {
                newAddress.append(c);
            }
            ++j;
        }
        return newAddress.toString().trim();
    }

    private static void formatNames(String[] names) {
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                int end;
                String name = names[i];
                String[] components = new String[5];
                int start = 0;
                int componentIndex = 0;
                while ((end = name.indexOf(59, start)) > 0) {
                    components[componentIndex] = name.substring(start, end);
                    ++componentIndex;
                    start = end + 1;
                }
                components[componentIndex] = name.substring(start);
                StringBuffer newName = new StringBuffer(100);
                VCardResultParser.maybeAppendComponent(components, 3, newName);
                VCardResultParser.maybeAppendComponent(components, 1, newName);
                VCardResultParser.maybeAppendComponent(components, 2, newName);
                VCardResultParser.maybeAppendComponent(components, 0, newName);
                VCardResultParser.maybeAppendComponent(components, 4, newName);
                names[i] = newName.toString().trim();
                ++i;
            }
        }
    }

    private static void maybeAppendComponent(String[] components, int i, StringBuffer newName) {
        if (components[i] != null) {
            newName.append(' ');
            newName.append(components[i]);
        }
    }
}

