/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.result.ExpandedProductParsedResult;
import com.google.zxing.client.result.ResultParser;
import java.util.Hashtable;

final class ExpandedProductResultParser
extends ResultParser {
    private ExpandedProductResultParser() {
    }

    public static ExpandedProductParsedResult parse(Result result) {
        BarcodeFormat format = result.getBarcodeFormat();
        if (!BarcodeFormat.RSS_EXPANDED.equals(format)) {
            return null;
        }
        String rawText = result.getText();
        if (rawText == null) {
            return null;
        }
        String productID = "-";
        String sscc = "-";
        String lotNumber = "-";
        String productionDate = "-";
        String packagingDate = "-";
        String bestBeforeDate = "-";
        String expirationDate = "-";
        String weight = "-";
        String weightType = "-";
        String weightIncrement = "-";
        String price = "-";
        String priceIncrement = "-";
        String priceCurrency = "-";
        Hashtable<String, String> uncommonAIs = new Hashtable<String, String>();
        int i = 0;
        while (i < rawText.length()) {
            String ai = ExpandedProductResultParser.findAIvalue(i, rawText);
            if ("ERROR".equals(ai)) {
                return null;
            }
            String value = ExpandedProductResultParser.findValue(i += ai.length() + 2, rawText);
            i += value.length();
            if ("00".equals(ai)) {
                sscc = value;
                continue;
            }
            if ("01".equals(ai)) {
                productID = value;
                continue;
            }
            if ("10".equals(ai)) {
                lotNumber = value;
                continue;
            }
            if ("11".equals(ai)) {
                productionDate = value;
                continue;
            }
            if ("13".equals(ai)) {
                packagingDate = value;
                continue;
            }
            if ("15".equals(ai)) {
                bestBeforeDate = value;
                continue;
            }
            if ("17".equals(ai)) {
                expirationDate = value;
                continue;
            }
            if ("3100".equals(ai) || "3101".equals(ai) || "3102".equals(ai) || "3103".equals(ai) || "3104".equals(ai) || "3105".equals(ai) || "3106".equals(ai) || "3107".equals(ai) || "3108".equals(ai) || "3109".equals(ai)) {
                weight = value;
                weightType = "KG";
                weightIncrement = ai.substring(3);
                continue;
            }
            if ("3200".equals(ai) || "3201".equals(ai) || "3202".equals(ai) || "3203".equals(ai) || "3204".equals(ai) || "3205".equals(ai) || "3206".equals(ai) || "3207".equals(ai) || "3208".equals(ai) || "3209".equals(ai)) {
                weight = value;
                weightType = "LB";
                weightIncrement = ai.substring(3);
                continue;
            }
            if ("3920".equals(ai) || "3921".equals(ai) || "3922".equals(ai) || "3923".equals(ai)) {
                price = value;
                priceIncrement = ai.substring(3);
                continue;
            }
            if ("3930".equals(ai) || "3931".equals(ai) || "3932".equals(ai) || "3933".equals(ai)) {
                if (value.length() < 4) {
                    return null;
                }
                price = value.substring(3);
                priceCurrency = value.substring(0, 3);
                priceIncrement = ai.substring(3);
                continue;
            }
            uncommonAIs.put(ai, value);
        }
        return new ExpandedProductParsedResult(productID, sscc, lotNumber, productionDate, packagingDate, bestBeforeDate, expirationDate, weight, weightType, weightIncrement, price, priceIncrement, priceCurrency, uncommonAIs);
    }

    private static String findAIvalue(int i, String rawText) {
        StringBuffer buf = new StringBuffer();
        char c = rawText.charAt(i);
        if (c != '(') {
            return "ERROR";
        }
        String rawTextAux = rawText.substring(i + 1);
        int index = 0;
        while (index < rawTextAux.length()) {
            char currentChar = rawTextAux.charAt(index);
            switch (currentChar) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    buf.append(currentChar);
                    break;
                }
                case ')': {
                    return buf.toString();
                }
                default: {
                    return "ERROR";
                }
            }
            ++index;
        }
        return buf.toString();
    }

    private static String findValue(int i, String rawText) {
        StringBuffer buf = new StringBuffer();
        String rawTextAux = rawText.substring(i);
        int index = 0;
        while (index < rawTextAux.length()) {
            char c = rawTextAux.charAt(index);
            if (c == '(') {
                if (!"ERROR".equals(ExpandedProductResultParser.findAIvalue(index, rawTextAux))) break;
                buf.append('(');
            } else {
                buf.append(c);
            }
            ++index;
        }
        return buf.toString();
    }
}

