/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AbstractDoCoMoResultParser;
import com.google.zxing.client.result.AddressBookParsedResult;
import java.util.Vector;

final class BizcardResultParser
extends AbstractDoCoMoResultParser {
    BizcardResultParser() {
    }

    public static AddressBookParsedResult parse(Result result) {
        String rawText = result.getText();
        if (rawText == null || !rawText.startsWith("BIZCARD:")) {
            return null;
        }
        String firstName = BizcardResultParser.matchSingleDoCoMoPrefixedField("N:", rawText, true);
        String lastName = BizcardResultParser.matchSingleDoCoMoPrefixedField("X:", rawText, true);
        String fullName = BizcardResultParser.buildName(firstName, lastName);
        String title = BizcardResultParser.matchSingleDoCoMoPrefixedField("T:", rawText, true);
        String org = BizcardResultParser.matchSingleDoCoMoPrefixedField("C:", rawText, true);
        String[] addresses = BizcardResultParser.matchDoCoMoPrefixedField("A:", rawText, true);
        String phoneNumber1 = BizcardResultParser.matchSingleDoCoMoPrefixedField("B:", rawText, true);
        String phoneNumber2 = BizcardResultParser.matchSingleDoCoMoPrefixedField("M:", rawText, true);
        String phoneNumber3 = BizcardResultParser.matchSingleDoCoMoPrefixedField("F:", rawText, true);
        String email = BizcardResultParser.matchSingleDoCoMoPrefixedField("E:", rawText, true);
        return new AddressBookParsedResult(BizcardResultParser.maybeWrap(fullName), null, BizcardResultParser.buildPhoneNumbers(phoneNumber1, phoneNumber2, phoneNumber3), BizcardResultParser.maybeWrap(email), null, addresses, org, null, title, null);
    }

    private static String[] buildPhoneNumbers(String number1, String number2, String number3) {
        int size;
        Vector<String> numbers = new Vector<String>(3);
        if (number1 != null) {
            numbers.addElement(number1);
        }
        if (number2 != null) {
            numbers.addElement(number2);
        }
        if (number3 != null) {
            numbers.addElement(number3);
        }
        if ((size = numbers.size()) == 0) {
            return null;
        }
        String[] result = new String[size];
        int i = 0;
        while (i < size) {
            result[i] = (String)numbers.elementAt(i);
            ++i;
        }
        return result;
    }

    private static String buildName(String firstName, String lastName) {
        if (firstName == null) {
            return lastName;
        }
        return lastName == null ? firstName : String.valueOf(firstName) + ' ' + lastName;
    }
}

