/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.tasks;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.tasks.RecordSourceLogger;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.http.XMLContentProducerFactory;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.http.entity.ContentProducer;
import org.w3c.dom.Document;

public class FileRecordSourceLogger
implements RecordSourceLogger {
    static ESLLogger logger = ESLLogger.getLogger(FileRecordSourceLogger.class);
    private final XMLContentProducerFactory contentProducerFactory = XMLContentProducerFactory.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logRecordSource(LabelId labelId, long externalId, Document document) {
        if (Config.isLogRecordsToFileEnabled()) {
            FileOutputStream outputStream = null;
            try {
                File logDirectory = new File(Config.getLogRecordsToFilePath());
                File file = new File(logDirectory, UUID.randomUUID() + ".xml");
                FileUtils.forceMkdir((File)logDirectory);
                outputStream = new FileOutputStream(file);
                ContentProducer contentProducer = this.contentProducerFactory.createContentProducer(document);
                contentProducer.writeTo((OutputStream)outputStream);
                StreamUtils.close((OutputStream)outputStream);
            }
            catch (Exception exc) {
                logger.warn("Failed to log record source for task with external ID %d for label %s", new Object[]{externalId, labelId.getLabelIdString()});
            }
            finally {
                StreamUtils.close(outputStream);
            }
        }
    }
}

