/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.tasks;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.tasks.RenderedImageConverter;
import at.mrdevelopment.esl.type.LabelTypeStringParser;
import at.mrdevelopment.toolkit.image.DitheringThreshold;
import at.mrdevelopment.toolkit.image.ImageUtils;
import com.google.common.base.Splitter;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ConfigBasedRenderedImageConverter
implements RenderedImageConverter {
    private static final int DEFAULT_ROTATION = 180;
    private final LabelTypeStringParser labelTypeParser = new LabelTypeStringParser();
    private String configValue = null;
    private HashMap<LabelType, Integer> latestMapping;

    public BufferedImage convert(LabelId labelId, BufferedImage image) {
        int rotation;
        if (image.getType() == 0) {
            BufferedImage convertedImg = new BufferedImage(image.getWidth(), image.getHeight(), 6);
            convertedImg.getGraphics().drawImage(image, 0, 0, null);
            image = convertedImg;
        }
        if (Config.isImageDithering()) {
            image = ImageUtils.ditherImage((BufferedImage)image, (DitheringThreshold)DitheringThreshold.DEFAULT);
        }
        if ((rotation = this.getRotationForLabel(labelId)) > 0) {
            image = ImageUtils.rotate((BufferedImage)image, (int)rotation);
        }
        return image;
    }

    private int getRotationForLabel(LabelId labelId) {
        Map<LabelType, Integer> mapping = this.parseLabelTypes();
        if (mapping.containsKey(labelId.getLabelType())) {
            return mapping.get(labelId.getLabelType());
        }
        return 0;
    }

    private String getCurrentConfigValue() {
        String value = Config.getRotateAllImagesForLabelType();
        return value == null ? "" : value;
    }

    private Map<LabelType, Integer> parseLabelTypes() {
        if (this.configValue != null && this.getCurrentConfigValue().equals(this.configValue)) {
            return this.latestMapping;
        }
        this.latestMapping = new HashMap();
        String currentConfigValue = this.getCurrentConfigValue();
        Iterable splittedTypes = Splitter.on((String)";").split((CharSequence)currentConfigValue);
        for (String splittedType : splittedTypes) {
            String[] split = StringUtils.split((String)splittedType, (String)"=");
            if (split.length <= 0) continue;
            LabelType labelType = this.labelTypeParser.parseLabelType(split[0]);
            int rotation = 180;
            if (split.length == 2) {
                try {
                    rotation = Integer.valueOf(split[1]);
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
            }
            if (labelType == null || rotation % 90 != 0) continue;
            if ((rotation == 90 || rotation == 270) && labelType.getDisplayWidth() != labelType.getDisplayHeight()) {
                rotation = 180;
            }
            this.latestMapping.put(labelType, rotation);
        }
        this.configValue = currentConfigValue;
        return this.latestMapping;
    }
}

