/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.usb;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicFields;
import at.mrdevelopment.esl.server.provisioning.service.ServiceModule;
import at.mrdevelopment.esl.server.provisioning.situation.AccessPointConfigSituation;
import at.mrdevelopment.esl.server.provisioning.usb.USBConfigHolder;

public class USBServiceModule
implements ServiceModule {
    private boolean sslEnabled;

    @Override
    public void receive(ModuleSpecificSettings settings) {
    }

    @Override
    public void init(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    @Override
    public void makeAccessPointServiceGoOffline(AccessPointConfigSituation situation, AccessPointInfoDataset infoDataset, EnvironmentProperties env) {
        infoDataset.removeAccessPointService(situation.getApId());
        ServiceAddress newAddress = situation.createServiceAddress(env);
        infoDataset.updateOfflineAccessPointAddress(situation.getApId(), newAddress, situation.canUpdate(), false);
    }

    @Override
    public ServiceAddress createServiceAddress(BaseExtConfigHolder configHolder) {
        USBConfigHolder usbConfigHolder = (USBConfigHolder)configHolder;
        ServiceAddress address = new ServiceAddress(this.sslEnabled, usbConfigHolder.getBasicConfig().getAddress(), usbConfigHolder.getBasicConfig().getPort(), "admin", "admin");
        return address;
    }

    @Override
    public ServiceAddress createServiceAddress(BasicConfigHolder configHolder) {
        ServiceAddress address = new ServiceAddress(this.sslEnabled, configHolder.getAddress(), configHolder.isSet(BasicFields.PORT) ? configHolder.getPort() : AccessPointType.USB_AP.getDefaultPort());
        return address;
    }

    @Override
    public ServiceAddress createDummyServiceAddress(EnvironmentProperties env) {
        return new ServiceAddress(this.sslEnabled, "", AccessPointType.USB_AP.getDefaultPort());
    }
}

