/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.usb;

import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.server.DiscoveredAccessPointsHolder;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.discovery.DiscoveryMode;
import at.mrdevelopment.esl.server.provisioning.discovery.DiscoveryModule;
import at.mrdevelopment.esl.server.provisioning.discovery.SearchResult;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagConfigHolder;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.List;

public class USBDiscoveryModule
implements DiscoveryModule {
    private static final ESLLogger logger = ESLLogger.getLogger(USBDiscoveryModule.class);
    private final DiscoveredAccessPointsHolder imagoAPs;

    USBDiscoveryModule(DiscoveredAccessPointsHolder discoveredImagoAPs) {
        this.imagoAPs = discoveredImagoAPs;
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void receive(ModuleSpecificSettings settings) {
    }

    public void shutdown() {
    }

    @Override
    public void init(boolean sslEnabled, boolean discoveryEnabled) {
    }

    @Override
    public List<AccessPointInfo> getDiscoveredAccessPoints() {
        LinkedList<AccessPointInfo> newList = new LinkedList<AccessPointInfo>();
        for (AccessPointInfo apInfo : this.imagoAPs.getAccessPoints()) {
            if (AccessPointTypeMapping.getType((int)apInfo.getAccessPointId()) != AccessPointType.USB_AP) continue;
            newList.add(apInfo);
        }
        return newList;
    }

    @Override
    public DiscoveryMode getMode() {
        return DiscoveryMode.WORK_IN_BACKGROUND;
    }

    @Override
    public SearchResult search() {
        SearchResult result = new SearchResult();
        for (AccessPointInfo apInfo : this.imagoAPs.getAccessPoints()) {
            if (!apInfo.isNew() || AccessPointTypeMapping.getType((int)apInfo.getAccessPointId()) != AccessPointType.USB_AP) continue;
            ImagotagConfigHolder temp = new ImagotagConfigHolder(apInfo.getDiscoveryTime());
            temp.getBasicConfig().setApId(apInfo.getAccessPointId());
            temp.getBasicConfig().setWirelessChannel(apInfo.getChannel());
            try {
                ServiceAddress serviceAddress = ServiceAddress.fromString((String)apInfo.getAddress());
                temp.getBasicConfig().setAddress(serviceAddress.getHost());
                temp.getBasicConfig().setPort(serviceAddress.getPort());
                apInfo.setNotNew();
                result.add(temp);
            }
            catch (MalformedURLException e) {
                logger.logExceptionIfDebugEnabled((Throwable)e);
            }
        }
        return result;
    }
}

