/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.softwareupdate;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.AccessPointUpdateStatus;
import at.mrdevelopment.esl.core.AccessPointUpdateType;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.AccessPointUpdateDataset;
import at.mrdevelopment.esl.persistence.dataset.AccessPointUpdatePackageDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.persistence.record.AccessPointUpdatePackageRecord;
import at.mrdevelopment.esl.persistence.record.AccessPointUpdateRecord;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.esl.server.provisioning.AccessPointTypeModules;
import at.mrdevelopment.esl.server.provisioning.ProvisioningModule;
import at.mrdevelopment.esl.server.provisioning.situation.AccessPointConfigSituation;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.AccessPointUpdateInterface;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.SoftwareUpdate;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.SoftwareUpdateException;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.UnsupportedUpdateException;
import at.mrdevelopment.esl.type.AccessPointUpdateError;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class AccessPointSoftwareUpdateProcessing
implements AccessPointUpdateInterface {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointSoftwareUpdateProcessing.class);
    private final AccessPointInfoDataset infoDataset;
    private final AccessPointUpdatePackageDataset updatePackageDataset;
    private final AccessPointUpdateDataset updateDataset;
    private final Map<Integer, AccessPointUpdateRecord> waitingUpdates = new HashMap<Integer, AccessPointUpdateRecord>();
    private final Map<Integer, AccessPointUpdateRecord> delayedUpdates = new LinkedHashMap<Integer, AccessPointUpdateRecord>();
    private final Object lock = new Object();

    public AccessPointSoftwareUpdateProcessing(AccessPointInfoDataset infoDataset, AccessPointUpdatePackageDataset updatePackageDataset, AccessPointUpdateDataset updateDataset) throws DatasetException {
        this.infoDataset = infoDataset;
        this.updatePackageDataset = updatePackageDataset;
        this.updateDataset = updateDataset;
    }

    public void init(Transaction<?> transaction) throws DatasetException {
        this.restoreUpdateCache(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreUpdateCache(Transaction<?> transaction) throws DatasetException {
        Collection<AccessPointUpdateRecord> unfinishedUpdateRecords = this.updateDataset.queryUnfinishedSoftwareUpdates(transaction);
        Object object = this.lock;
        synchronized (object) {
            for (AccessPointUpdateRecord record : unfinishedUpdateRecords) {
                if (record.getStatus().isWaiting()) {
                    this.waitingUpdates.put(record.getAccessPointId(), record);
                    continue;
                }
                if (!record.getStatus().isDelayed()) continue;
                this.delayedUpdates.put(record.getAccessPointId(), record);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpdates(Map<Integer, AccessPointConfigSituation> apConfigMapping, ProvisioningModule provisioningModule, Transaction<?> transaction) throws DatasetException {
        Collection<AccessPointInfo> accessPointInfos = this.queryAccessPointInfos(transaction);
        Object object = this.lock;
        synchronized (object) {
            if (this.updatePackageDataset.isInitialized()) {
                this.updateWaitingUpdates(accessPointInfos, transaction);
                if (Config.isAccessPointUpdatesEnabled()) {
                    for (AccessPointInfo accessPointInfo : accessPointInfos) {
                        this.handleSoftwareUpdate(accessPointInfo, transaction);
                    }
                }
                List<SoftwareUpdate> newUpdates = this.updateDelayedUpdates(transaction);
                this.sendUpdates(provisioningModule, apConfigMapping, newUpdates, transaction);
            }
        }
    }

    private void sendUpdates(ProvisioningModule provisioningModule, Map<Integer, AccessPointConfigSituation> apConfigMapping, List<SoftwareUpdate> softwareUpdates, Transaction<?> transaction) throws DatasetException {
        for (SoftwareUpdate update : softwareUpdates) {
            try {
                logger.debug("Sending software update to access point %d", new Object[]{update.getAccessPointId()});
                AccessPointTypeModules accessPointTypeModules = provisioningModule.getAccessPointTypeModules(update.getAccessPointId());
                accessPointTypeModules.getSoftwareUpdateModule().sendSoftwareUpdate(apConfigMapping.get(update.getAccessPointId()), update);
                logger.info("Software update sent to access point %d", new Object[]{update.getAccessPointId()});
            }
            catch (UnsupportedUpdateException exc) {
                logger.warn("Software update for access point %d not supported: %s", new Object[]{update.getAccessPointId(), exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                this.updateStatus(update.getUpdate(), AccessPointUpdateStatus.ERROR, AccessPointUpdateError.ERROR_CODE_UNSUPPORTED_OPERATION, transaction);
                this.waitingUpdates.remove(update.getAccessPointId());
            }
            catch (SoftwareUpdateException exc) {
                logger.warn("Could not send software update to access point %d: %s", new Object[]{update.getAccessPointId(), exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                this.updateStatus(update.getUpdate(), AccessPointUpdateStatus.FAILED, null, transaction);
                this.waitingUpdates.remove(update.getAccessPointId());
                this.checkAndCreateRetry(update.getUpdate(), transaction);
            }
            catch (Exception exc) {
                logger.warn("Unknown error during software update for access point %d: %s", new Object[]{update.getAccessPointId(), exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                this.updateStatus(update.getUpdate(), AccessPointUpdateStatus.ERROR, AccessPointUpdateError.ERROR_CODE_UNKNOWN, transaction);
                this.waitingUpdates.remove(update.getAccessPointId());
            }
        }
    }

    private void updateStatus(AccessPointUpdateRecord update, AccessPointUpdateStatus status, AccessPointUpdateError updateError, Transaction<?> transaction) throws DatasetException {
        update.setStatus(status);
        update.setUpdateError(updateError);
        if (updateError != null && updateError.isClearRetries()) {
            update.setRetriesLeft(Integer.valueOf(0));
        }
        this.updateDataset.store((Commitable)update, UserId.SYSTEM, transaction);
    }

    private void checkAndCreateRetry(AccessPointUpdateRecord update, Transaction<?> transaction) throws DatasetException {
        if (!update.getStatus().isSuccessful() && update.getStatus().isFinished() && update.hasRetriesLeft()) {
            logger.info("Retrying software update for access point %d.", new Object[]{update.getAccessPointId()});
            AccessPointUpdateRecord retryUpdate = this.createRetry(update);
            this.updateDataset.store((Commitable)retryUpdate, UserId.SYSTEM, transaction);
            this.delayedUpdates.put(update.getAccessPointId(), retryUpdate);
        }
    }

    private List<SoftwareUpdate> updateDelayedUpdates(Transaction<?> transaction) throws DatasetException {
        ArrayList<SoftwareUpdate> updates = new ArrayList<SoftwareUpdate>();
        while (this.waitingUpdates.size() < Config.getAccessPointUpdateMaxConcurrentUpdates() && !this.delayedUpdates.isEmpty()) {
            Integer accessPointId = this.delayedUpdates.keySet().iterator().next();
            AccessPointUpdateRecord update = this.delayedUpdates.remove(accessPointId);
            this.updateStatus(update, AccessPointUpdateStatus.WAITING, null, transaction);
            this.waitingUpdates.put(accessPointId, update);
            updates.add(new SoftwareUpdate(accessPointId, this.updatePackageDataset.queryByChecksum(update.getUpdateHash()), update));
            logger.info("Scheduling software update for access point %d", new Object[]{update.getAccessPointId()});
        }
        return updates;
    }

    private Collection<AccessPointInfo> queryAccessPointInfos(Transaction<?> transaction) throws DatasetException {
        List<AccessPointInfo> accessPointInfos = this.infoDataset.queryAll(transaction);
        return Collections2.filter(accessPointInfos, (Predicate)new Predicate<AccessPointInfo>(){

            public boolean apply(AccessPointInfo accessPointInfo) {
                return !accessPointInfo.isDiscovered();
            }
        });
    }

    private void updateWaitingUpdates(final Collection<AccessPointInfo> accessPointInfos, Transaction<?> transaction) throws DatasetException {
        for (AccessPointInfo accessPointInfo : accessPointInfos) {
            AccessPointUpdateRecord update = this.waitingUpdates.get(accessPointInfo.getAccessPointId());
            if (update == null) continue;
            AccessPointUpdatePackageRecord updatePackage = this.updatePackageDataset.queryByChecksum(update.getUpdateHash());
            AccessPointUpdateStatus status = update.getStatus();
            AccessPointUpdateError updateError = update.getUpdateError();
            if (updatePackage != null) {
                status = this.updateStatus(updatePackage, update, accessPointInfo);
                updateError = null;
            } else {
                logger.info("Software update for access point %d set to error as update package has been removed.", new Object[]{update.getAccessPointId()});
                status = AccessPointUpdateStatus.ERROR;
                updateError = AccessPointUpdateError.ERROR_CODE_RESOURCE_NOT_AVAILABLE;
            }
            this.updateStatus(update, status, updateError, transaction);
            if (!update.getStatus().isFinished()) continue;
            this.waitingUpdates.remove(accessPointInfo.getAccessPointId());
            this.checkAndCreateRetry(update, transaction);
        }
        Collection remainingUpdates = Collections2.filter(this.waitingUpdates.values(), (Predicate)new Predicate<AccessPointUpdateRecord>(){

            public boolean apply(AccessPointUpdateRecord update) {
                for (AccessPointInfo accessPointInfo : accessPointInfos) {
                    if (!accessPointInfo.getAccessPointId().equals(update.getAccessPointId())) continue;
                    return false;
                }
                return true;
            }
        });
        for (AccessPointUpdateRecord update : remainingUpdates) {
            logger.info("Software update for access point %d set to error as entry is missing.", new Object[]{update.getAccessPointId()});
            this.updateStatus(update, AccessPointUpdateStatus.ERROR, AccessPointUpdateError.ERROR_CODE_UNREGISTERED, transaction);
            this.waitingUpdates.remove(update.getAccessPointId());
        }
    }

    private AccessPointUpdateRecord createRetry(AccessPointUpdateRecord update) {
        return new AccessPointUpdateRecord(update.getAccessPointId(), update.getUpdateType(), update.getVersion(), update.getUpdateHash(), update.getRetriesLeft() - 1, AccessPointUpdateStatus.DELAYED);
    }

    private AccessPointUpdateRecord createDelayed(AccessPointInfo accessPointInfo, AccessPointUpdatePackageRecord updatePackage) {
        return new AccessPointUpdateRecord(accessPointInfo.getAccessPointId(), AccessPointUpdateType.SOFTWARE_UPDATE, accessPointInfo.getVersion(), updatePackage.getChecksum(), Config.getAccessPointUpdateRetryCount(), AccessPointUpdateStatus.DELAYED);
    }

    private AccessPointUpdateStatus updateStatus(AccessPointUpdatePackageRecord updatePackage, AccessPointUpdateRecord update, AccessPointInfo accessPointInfo) {
        boolean timeoutReached = update.getCreatedAt().isBefore((ReadableInstant)DateTime.now().minusMinutes(Config.getAccessPointUpdateTimeoutInMinutes()));
        if (updatePackage.getUpdateVersion().toString().equals(accessPointInfo.getVersion().toString())) {
            logger.info("Software update for access point %d successful.", new Object[]{accessPointInfo.getAccessPointId()});
            return AccessPointUpdateStatus.SUCCESSFUL;
        }
        if (timeoutReached) {
            logger.info("Software update for access point %d timed out.", new Object[]{accessPointInfo.getAccessPointId()});
            return AccessPointUpdateStatus.FAILED;
        }
        return update.getStatus();
    }

    private void handleSoftwareUpdate(AccessPointInfo accessPointInfo, Transaction<?> transaction) throws DatasetException {
        AccessPointUpdatePackageRecord updatePackage;
        if (!this.isUpdatePending(accessPointInfo.getAccessPointId()) && accessPointInfo.isOnline() && (updatePackage = this.updatePackageDataset.getUpdatePackage(accessPointInfo)) != null) {
            try {
                List<AccessPointUpdateRecord> oldUpdates = this.updateDataset.queryByAccessPointIdAndHash(accessPointInfo.getAccessPointId(), updatePackage.getChecksum(), transaction);
                if (oldUpdates == null || oldUpdates.isEmpty()) {
                    logger.info("New delayed software update to version %s selected for access point %d.", new Object[]{updatePackage.getUpdateVersion().getVersionString(), accessPointInfo.getAccessPointId()});
                    AccessPointUpdateRecord delayedUpdate = this.createDelayed(accessPointInfo, updatePackage);
                    this.updateDataset.store((Commitable)delayedUpdate, UserId.SYSTEM, transaction);
                    this.delayedUpdates.put(accessPointInfo.getAccessPointId(), delayedUpdate);
                }
            }
            catch (Exception exc) {
                throw new DatasetException((Throwable)exc);
            }
        }
    }

    private boolean isUpdatePending(Integer accessPointId) {
        return this.waitingUpdates.containsKey(accessPointId) || this.delayedUpdates.containsKey(accessPointId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceSoftwareUpdate(Collection<Integer> accessPointIds, AccessPointUpdatePackageRecord updatePackage, Transaction<?> transaction) {
        Object object = this.lock;
        synchronized (object) {
            for (Integer accessPointId : accessPointIds) {
                if (this.isUpdatePending(accessPointId)) continue;
                try {
                    AccessPointInfo accessPointInfo = this.infoDataset.queryById((long)accessPointId.intValue(), transaction);
                    if (accessPointInfo == null || !accessPointInfo.isOnline()) continue;
                    logger.info("Adding forced software update for access point %d", new Object[]{accessPointId});
                    AccessPointUpdateRecord delayedUpdate = this.createDelayed(accessPointInfo, updatePackage);
                    this.delayedUpdates.put(accessPointId, delayedUpdate);
                    this.updateDataset.store((Commitable)delayedUpdate, UserId.SYSTEM, transaction);
                }
                catch (DatasetException exc) {
                    logger.warn("No access point information to force a software update for access point %d", new Object[]{accessPointId});
                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                }
            }
        }
    }
}

