/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.situation;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.server.provisioning.AccessPointTypeModules;
import at.mrdevelopment.esl.server.provisioning.PeriodicSituation;
import at.mrdevelopment.esl.server.provisioning.Status;
import at.mrdevelopment.esl.server.provisioning.configuration.OperationResult;
import at.mrdevelopment.esl.server.provisioning.configuration.SuccessState;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.DecisionMode;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.TargetConfigValidity;
import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.ConfigField;
import at.mrdevelopment.esl.server.provisioning.field.Difference;
import at.mrdevelopment.esl.server.provisioning.situation.InitHandler;
import at.mrdevelopment.esl.server.provisioning.situation.OperationModeSituation;
import at.mrdevelopment.esl.server.provisioning.situation.TemporaryContext;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Collections;

public class AccessPointConfigSituation {
    private static final ESLLogger logger = ESLLogger.getLogger(AccessPointConfigSituation.class);
    private BasicConfigHolder targetConfiguration;
    BaseExtConfigHolder currentConfiguration;
    private PeriodicSituation exposer;
    AccessPointTypeModules modules;
    private TargetConfigValidity validity;
    private long lastUpdateTime;
    private long lastInitTime;
    private Status lastStatus;
    private Difference currentConfigDifference;
    private InitHandler initHandler;
    private TemporaryContext context;
    private boolean commonSettingsNeedUpdate;
    private boolean accessPointsRequireReinit;
    private final OperationModeSituation operationModeSituation;

    public AccessPointConfigSituation(AccessPointTypeModules modules, AccessPointInfoDataset infoDataset, BasicConfigHolder targetConfiguration) {
        this.modules = modules;
        this.targetConfiguration = targetConfiguration;
        this.exposer = new PeriodicSituation();
        this.lastUpdateTime = 0L;
        this.lastInitTime = 0L;
        this.lastStatus = Status.UNKNOWN;
        this.currentConfigDifference = new Difference(false, false);
        this.initHandler = new InitHandler(this);
        this.context = new TemporaryContext();
        this.commonSettingsNeedUpdate = true;
        this.accessPointsRequireReinit = false;
        this.operationModeSituation = new OperationModeSituation(this, infoDataset);
    }

    public AccessPointConfigSituation(AccessPointTypeModules modules, AccessPointInfoDataset infoDataset, BaseExtConfigHolder currentConfig) {
        this.modules = modules;
        this.currentConfiguration = currentConfig;
        this.exposer = new PeriodicSituation();
        this.lastUpdateTime = 0L;
        this.lastInitTime = 0L;
        this.lastStatus = Status.UNKNOWN;
        this.currentConfigDifference = new Difference(true, true);
        this.initHandler = new InitHandler(this);
        this.context = new TemporaryContext();
        this.commonSettingsNeedUpdate = true;
        this.accessPointsRequireReinit = false;
        this.operationModeSituation = new OperationModeSituation(this, infoDataset);
    }

    public OperationModeSituation getOperationModeSituation() {
        return this.operationModeSituation;
    }

    AccessPointTypeModules modules() {
        return this.modules;
    }

    public TemporaryContext context() {
        return this.context;
    }

    public int getApId() {
        return this.targetConfiguration.getApId();
    }

    public BasicConfigHolder getTargetConfig() {
        return this.targetConfiguration;
    }

    public BaseExtConfigHolder getCurrentConfig() {
        return this.currentConfiguration;
    }

    public boolean didBasicCurrentConfigChange() {
        return this.currentConfigDifference.isBasicDifferent();
    }

    public Status lastStatus() {
        return this.lastStatus;
    }

    public void setOffline() {
        this.lastStatus = Status.OFFLINE;
    }

    public void setOnline() {
        this.lastStatus = Status.ONLINE;
    }

    public boolean likelyDiscoveredAfterLastUpdate(BaseExtConfigHolder discovered) {
        return this.modules.getDecisionLogic().likelyHappenedAfterLastUpdate(this.lastUpdateTime, discovered);
    }

    public boolean anyDifferentFromTarget(BasicConfigHolder config) {
        return this.targetConfiguration == null || this.targetConfiguration.isDifferentFrom(config, Collections.<ConfigField>emptyList());
    }

    public boolean anyDifferentFromCurrent(BaseExtConfigHolder extConfig) {
        this.currentConfigDifference = this.currentConfiguration == null ? new Difference(true, true) : this.currentConfiguration.isDifferentFrom(extConfig);
        return this.currentConfigDifference.isDifferent();
    }

    public void setNewCurrent(BaseExtConfigHolder extConfig) {
        this.currentConfiguration = extConfig.copy();
    }

    public void setCurrentDiscoveryTime(long discoveryTime) {
        this.currentConfiguration.setDiscoveryTime(discoveryTime);
    }

    public void overtakeTarget(BasicConfigHolder basicConfig) {
        this.targetConfiguration = basicConfig;
    }

    public void clearTargetAndReset() {
        this.targetConfiguration = null;
        this.lastUpdateTime = 0L;
        this.lastInitTime = 0L;
        this.lastStatus = Status.UNKNOWN;
        this.commonSettingsNeedUpdate = true;
        this.currentConfigDifference = new Difference(true, true);
    }

    public void clearCurrentIfExpired(long currentTimeInMillis) {
        if (this.currentConfiguration != null && this.currentConfiguration.hasExpired(currentTimeInMillis)) {
            logger.info("Removing discovered data for AP = %d.", new Object[]{this.currentConfiguration.getBasicConfig().getApId()});
            this.currentConfiguration = null;
        }
    }

    public void clearValidity() {
        this.validity = null;
    }

    public boolean isCentralizedMode() {
        return this.targetConfiguration.isAutoConfig();
    }

    public DecisionMode getDecisionMode() {
        return this.targetConfiguration.isAutoConfig() ? DecisionMode.CENTRALIZED : DecisionMode.MANUAL;
    }

    public TargetConfigValidity getTargetConfigurationValidity() {
        if (this.validity == null) {
            this.validity = this.targetConfiguration != null ? this.modules.getDecisionLogic().getValidity(this.targetConfiguration, this.getDecisionMode()) : TargetConfigValidity.NOT_VALID;
        }
        return this.validity;
    }

    public boolean isTargetConfigNew() {
        return this.targetConfiguration.isNew();
    }

    public boolean isCurrentConfigNew() {
        return this.currentConfiguration.getBasicConfig().isNew();
    }

    public boolean isAnyConfigNew() {
        return this.targetConfiguration.isNew() || this.currentConfiguration.getBasicConfig().isNew();
    }

    public void setTargetConfigToOld() {
        this.targetConfiguration.setToOld();
    }

    public void setBothConfigsToOld() {
        this.targetConfiguration.setToOld();
        if (this.currentConfiguration != null) {
            this.currentConfiguration.getBasicConfig().setToOld();
            this.currentConfigDifference = new Difference(false, false);
        }
    }

    public boolean isCurrentConfigurationPresent() {
        return this.currentConfiguration != null;
    }

    public boolean isTargetConfigurationPresent() {
        return this.targetConfiguration != null;
    }

    public boolean isEmpty() {
        return this.targetConfiguration == null && this.currentConfiguration == null;
    }

    public boolean requireConfigUpdateDueCommonSettingsChange() {
        if (this.modules.getDecisionLogic().commonSettingsChanged()) {
            this.commonSettingsNeedUpdate = true;
        }
        return this.commonSettingsNeedUpdate;
    }

    public boolean accessPointsRequireReinit() {
        if (this.modules.getDecisionLogic().accessPointsRequireReinit()) {
            this.accessPointsRequireReinit = true;
        }
        return this.accessPointsRequireReinit;
    }

    public void accessPointDoNotRequireReinit() {
        this.accessPointsRequireReinit = false;
    }

    public boolean isThinModeEnabled() {
        return this.modules.getDecisionLogic().getThinConfig().isThinModeEnabled();
    }

    public boolean canUpdate() {
        return this.modules.getDecisionLogic().isUpdateApplicable(this.targetConfiguration, this.currentConfiguration);
    }

    public boolean setup() {
        return this.modules.getConfig().setup(this.currentConfiguration);
    }

    public boolean update() {
        OperationResult result = this.modules.getConfig().updateAccessPointConfig(this.targetConfiguration, this.currentConfiguration);
        if (result.getState() != SuccessState.NOT_SUCCESSFUL) {
            this.currentConfiguration.customOvertake(result.getExtHolder());
            this.lastUpdateTime = System.currentTimeMillis();
        }
        this.context.updateSuccessful(result.getState() == SuccessState.SUCCESSFUL);
        this.context.setUpdateRequiresReinit(result.requiresServiceReinit());
        if (this.commonSettingsNeedUpdate && this.context.wasUpdateSuccessful()) {
            this.exposer.resetCount();
        }
        this.commonSettingsNeedUpdate = !this.context.wasUpdateSuccessful();
        return this.context.wasUpdateSuccessful();
    }

    public ServiceAddress createServiceAddress(EnvironmentProperties env) {
        if (this.getDecisionMode() == DecisionMode.CENTRALIZED) {
            if (this.currentConfiguration != null) {
                return this.modules.getService().createServiceAddress(this.currentConfiguration);
            }
            return this.modules.getService().createDummyServiceAddress(env);
        }
        if (this.validity == TargetConfigValidity.MANUAL_ID_ONLY) {
            if (this.currentConfiguration != null) {
                return this.modules.getService().createServiceAddress(this.currentConfiguration);
            }
            return this.modules.getService().createDummyServiceAddress(env);
        }
        return this.modules.getService().createServiceAddress(this.targetConfiguration);
    }

    public boolean isDiscoveryEnabled() {
        return this.modules.getLatestSettings().isDiscoveryEnabled();
    }

    public boolean canComeOnlineWithCurrentSituation() {
        return this.modules.getDecisionLogic().canComeOnlineWithCurrentSituation(this.targetConfiguration, this.currentConfiguration);
    }

    public void makeAccessPointServiceGoOffline(AccessPointInfoDataset infoDataset, EnvironmentProperties env) {
        this.modules.getService().makeAccessPointServiceGoOffline(this, infoDataset, env);
    }

    public void updatePeriodic() {
        this.exposer.update(this.targetConfiguration, this.currentConfiguration);
    }

    public PeriodicSituation periodic() {
        return this.exposer;
    }

    public InitHandler initHandler() {
        return this.initHandler;
    }

    public boolean didAuthenticationFail() {
        return this.modules.getDecisionLogic().didAuthenticationFail(this.currentConfiguration);
    }

    public long lastInitTime() {
        return this.lastInitTime;
    }

    public void updateLastInitTime() {
        this.lastInitTime = System.currentTimeMillis();
    }

    public OperationModeSituation operationModeSituation() {
        return this.operationModeSituation;
    }
}

