/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.simulated;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicFields;
import at.mrdevelopment.esl.server.provisioning.service.ServiceModule;
import at.mrdevelopment.esl.server.provisioning.simulated.SimulatedConfigHolder;
import at.mrdevelopment.esl.server.provisioning.situation.AccessPointConfigSituation;

public class SimulatedServiceModule
implements ServiceModule {
    private boolean sslEnabled;

    @Override
    public void receive(ModuleSpecificSettings settings) {
    }

    @Override
    public void init(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    @Override
    public void makeAccessPointServiceGoOffline(AccessPointConfigSituation situation, AccessPointInfoDataset infoDataset, EnvironmentProperties env) {
        infoDataset.removeAccessPointService(situation.getApId());
        ServiceAddress newAddress = situation.createServiceAddress(env);
        infoDataset.updateOfflineAccessPointAddress(situation.getApId(), newAddress, situation.canUpdate(), situation.isThinModeEnabled());
    }

    @Override
    public ServiceAddress createServiceAddress(BaseExtConfigHolder configHolder) {
        SimulatedConfigHolder simulatedConfigHolder = (SimulatedConfigHolder)configHolder;
        ServiceAddress address = new ServiceAddress(this.sslEnabled, simulatedConfigHolder.getBasicConfig().getAddress(), simulatedConfigHolder.getBasicConfig().getPort(), "admin", "admin");
        return address;
    }

    @Override
    public ServiceAddress createServiceAddress(BasicConfigHolder configHolder) {
        ServiceAddress address = new ServiceAddress(this.sslEnabled, configHolder.getAddress(), configHolder.isSet(BasicFields.PORT) ? configHolder.getPort() : AccessPointType.SIMULATED.getDefaultPort());
        return address;
    }

    @Override
    public ServiceAddress createDummyServiceAddress(EnvironmentProperties env) {
        return new ServiceAddress(this.sslEnabled, "", AccessPointType.SIMULATED.getDefaultPort());
    }
}

