/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.simulated;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.field.ConfigField;
import at.mrdevelopment.esl.server.provisioning.imagotag.ReinitConfigHolder;
import at.mrdevelopment.esl.server.provisioning.imagotag.ReinitFields;
import java.util.Collections;

public class SimulatedModuleSettings
implements ModuleSpecificSettings {
    private final ReinitConfigHolder reinitSettings;
    private boolean reinitSettingsChanged;

    public SimulatedModuleSettings() {
        boolean thinModeEnabled = Config.isAccessPointUseThinMode();
        this.reinitSettings = new ReinitConfigHolder(thinModeEnabled);
        this.reinitSettingsChanged = false;
    }

    @Override
    public void calculateDifferences(ModuleSpecificSettings other) {
        if (other != null) {
            SimulatedModuleSettings temp = (SimulatedModuleSettings)other;
            this.reinitSettingsChanged = this.reinitSettings.isDifferentFrom(temp.reinitSettings, Collections.<ConfigField>emptyList());
        } else {
            this.reinitSettingsChanged = false;
        }
    }

    @Override
    public boolean connectionSettingsChanged() {
        return false;
    }

    @Override
    public boolean commonSettingsChanged() {
        return false;
    }

    @Override
    public boolean isDiscoveryEnabled() {
        return false;
    }

    @Override
    public boolean accessPointsRequireReinit() {
        return this.reinitSettingsChanged;
    }

    @Override
    public boolean thinModeEnabled() {
        return this.reinitSettings.get(ReinitFields.USE_THIN_MODE).getBoolValue();
    }
}

