/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.message;

import at.mrdevelopment.esl.core.problem.ProblemIdentifier;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.server.provisioning.message.AccessPointQueryById;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AccessPointProvisioningQueries {
    private final HashMap<ProblemIdentifier, AccessPointQueryById> problemToQueryMapping = new HashMap(16);
    private final HashMap<Integer, ProblemIdentifier> apIdToProblemMapping = new HashMap(40, 0.9f);
    private final AccessPointQueryById authenticationFailedQuery;
    private final AccessPointQueryById apNotAvailableQuery;
    private final AccessPointQueryById discoveryIncompleteQuery;
    private final Lock lock = new ReentrantLock();

    public AccessPointProvisioningQueries(AccessPointInfoDataset apInfoDataset) {
        this.problemToQueryMapping.put(ProblemIdentifier.MANUAL_ID_ONLY, new AccessPointQueryById((Dataset<AccessPointInfo>)apInfoDataset, "accesspointinfo/manualidonly"));
        this.problemToQueryMapping.put(ProblemIdentifier.MANUAL_NOT_DISCOVERED, new AccessPointQueryById((Dataset<AccessPointInfo>)apInfoDataset, "accesspointinfo/manualnotdiscovered"));
        this.problemToQueryMapping.put(ProblemIdentifier.MANUAL_NOT_VALID, new AccessPointQueryById((Dataset<AccessPointInfo>)apInfoDataset, "accesspointinfo/manualnotvalid"));
        this.problemToQueryMapping.put(ProblemIdentifier.CENTRALIZED_UPDATE_OK, new AccessPointQueryById((Dataset<AccessPointInfo>)apInfoDataset, "accesspointinfo/centralizedupdateok"));
        this.problemToQueryMapping.put(ProblemIdentifier.CENTRALIZED_DISABLED, new AccessPointQueryById((Dataset<AccessPointInfo>)apInfoDataset, "accesspointinfo/centralizeddisabled"));
        this.problemToQueryMapping.put(ProblemIdentifier.CENTRALIZED_UPDATE_FAILED, new AccessPointQueryById((Dataset<AccessPointInfo>)apInfoDataset, "accesspointinfo/centralizedupdatefailed"));
        this.problemToQueryMapping.put(ProblemIdentifier.CENTRALIZED_UPDATE_NOT_NEEDED, new AccessPointQueryById((Dataset<AccessPointInfo>)apInfoDataset, "accesspointinfo/centralizednotneeded"));
        this.problemToQueryMapping.put(ProblemIdentifier.CENTRALIZED_NOT_DISCOVERED, new AccessPointQueryById((Dataset<AccessPointInfo>)apInfoDataset, "accesspointinfo/centralizednotdiscovered"));
        this.problemToQueryMapping.put(ProblemIdentifier.CENTRALIZED_NOT_VALID, new AccessPointQueryById((Dataset<AccessPointInfo>)apInfoDataset, "accesspointinfo/centralizednotvalid"));
        this.problemToQueryMapping.put(ProblemIdentifier.UNRESOLVABLE, new AccessPointQueryById((Dataset<AccessPointInfo>)apInfoDataset, "accesspointinfo/unresolvable"));
        this.problemToQueryMapping.put(ProblemIdentifier.INIT_FAILED, new AccessPointQueryById((Dataset<AccessPointInfo>)apInfoDataset, "accesspointinfo/initializationfailed"));
        this.apNotAvailableQuery = new AccessPointQueryById((Dataset<AccessPointInfo>)apInfoDataset, "accesspointinfo/notavailable");
        this.authenticationFailedQuery = new AccessPointQueryById((Dataset<AccessPointInfo>)apInfoDataset, "accesspointinfo/accessrefused");
        this.discoveryIncompleteQuery = new AccessPointQueryById((Dataset<AccessPointInfo>)apInfoDataset, "accesspointinfo/discoveryincomplete");
    }

    private AccessPointQueryById inner_getQuery(ProblemIdentifier identifier) {
        AccessPointQueryById query = this.problemToQueryMapping.get(identifier);
        if (query == null) {
            throw new IllegalArgumentException("Problem " + identifier.getIdentifier() + " does not have a matching query.");
        }
        return query;
    }

    private void inner_removeProblem(Integer apId) {
        ProblemIdentifier temp = this.apIdToProblemMapping.get(apId);
        if (temp != null) {
            AccessPointQueryById query = this.inner_getQuery(temp);
            query.removeApId(apId);
            this.apIdToProblemMapping.remove(apId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessPointQueryById getQuery(ProblemIdentifier identifier) {
        AccessPointQueryById result;
        if (identifier == ProblemIdentifier.DISCOVERY_INCOMPLETE) {
            return this.discoveryIncompleteQuery;
        }
        if (identifier == ProblemIdentifier.AP_NOT_AVAILABLE) {
            return this.apNotAvailableQuery;
        }
        if (identifier == ProblemIdentifier.AUTHENTICATION_FAILED) {
            return this.authenticationFailedQuery;
        }
        this.lock.lock();
        try {
            result = this.inner_getQuery(identifier);
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProblem(ProblemIdentifier identifier, Integer apId) {
        this.lock.lock();
        try {
            this.inner_removeProblem(apId);
            AccessPointQueryById query = this.inner_getQuery(identifier);
            query.addApId(apId);
            this.apIdToProblemMapping.put(apId, identifier);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetProblem(Integer apId) {
        this.lock.lock();
        try {
            this.inner_removeProblem(apId);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearDiscoveryRelated() {
        this.discoveryIncompleteQuery.removeAllApIds();
        this.apNotAvailableQuery.removeAllApIds();
        this.authenticationFailedQuery.removeAllApIds();
    }

    public void apNotAvailable(Integer apId) {
        this.apNotAvailableQuery.addApId(apId);
    }

    public void authenticationFailed(Integer apId) {
        this.authenticationFailedQuery.addApId(apId);
    }

    public void discoveryIncompleteFor(Integer apId) {
        this.discoveryIncompleteQuery.addApId(apId);
    }
}

