/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.lancom;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomFields;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomModuleSettings;
import at.mrdevelopment.esl.server.provisioning.situation.AccessPointConfigSituation;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.SoftwareUpdate;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.SoftwareUpdateException;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.SoftwareUpdateModule;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.lancom.ConnectResult;
import at.mrdevelopment.toolkit.lancom.LancomConfigClient;
import at.mrdevelopment.toolkit.lancom.LancomException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.sshtools.ssh.SshException;

public class LancomSoftwareUpdateModule
implements SoftwareUpdateModule {
    static ESLLogger logger = ESLLogger.getLogger(LancomSoftwareUpdateModule.class);
    private final LancomConfigClient client = new LancomConfigClient();
    private LancomModuleSettings settings;

    @Override
    public void sendSoftwareUpdate(AccessPointConfigSituation accessPointConfigSituation, SoftwareUpdate softwareUpdate) throws SoftwareUpdateException {
        this.setupConnection(accessPointConfigSituation);
        try {
            this.client.sendSoftwareUpdateCommand(this.createUrlForUpdate(softwareUpdate));
        }
        catch (LancomException exc) {
            throw new SoftwareUpdateException(exc);
        }
        catch (InitializationException exc) {
            throw new SoftwareUpdateException(exc);
        }
    }

    private String createUrlForUpdate(SoftwareUpdate softwareUpdate) throws InitializationException {
        return new ServiceAddress(softwareUpdate.getUpdatePackage().isWebserverSsl() ? "https" : "http", this.getLocalAddress(), softwareUpdate.getUpdatePackage().getWebserverListenPort(), "service/updatepackage/lancom/" + softwareUpdate.getUpdatePackage().getId().toString() + ".upx").getConnectionString();
    }

    private String getLocalAddress() throws InitializationException {
        return new EnvironmentProperties(false).getIPAddress();
    }

    private void setupConnection(AccessPointConfigSituation accessPointConfigSituation) throws SoftwareUpdateException {
        BaseExtConfigHolder currentConfig = accessPointConfigSituation.getCurrentConfig();
        if (logger.isDebugEnabled()) {
            logger.debug("Connecting to " + currentConfig.getBasicConfig().getAddress() + " ...");
        }
        try {
            boolean success;
            this.client.setLogin(this.settings.getUsername(), this.settings.getPassword());
            int sshPort = currentConfig.isSet(LancomFields.SSH_PORT) ? currentConfig.get(LancomFields.SSH_PORT).getIntValue() : 22;
            ConnectResult result = this.client.connect(currentConfig.getBasicConfig().getAddress(), sshPort);
            boolean bl = success = result == ConnectResult.SUCCESS;
            if (!success) {
                throw new SoftwareUpdateException("Could not connect to Lancom access point", new Object[0]);
            }
        }
        catch (LancomException exc) {
            logger.error("Could not connect to %d at %s. Error: %s.", new Object[]{currentConfig.getBasicConfig().getApId(), currentConfig.getBasicConfig().getAddress(), exc.getMessage()});
            throw new SoftwareUpdateException(exc);
        }
    }

    @Override
    public void receive(ModuleSpecificSettings newSettings) {
        if (newSettings instanceof LancomModuleSettings) {
            this.settings = (LancomModuleSettings)newSettings;
        }
    }
}

