/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.lancom;

import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.server.provisioning.AccessPointModulesProvider;
import at.mrdevelopment.esl.server.provisioning.SettingsCreator;
import at.mrdevelopment.esl.server.provisioning.configuration.ConfigurationModule;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.DecisionLogicModule;
import at.mrdevelopment.esl.server.provisioning.discovery.DiscoveryModule;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomConfigurationModule;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomDecisionLogicModule;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomDiscoveryModule;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomServiceModule;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomSettingsCreator;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomSoftwareUpdateModule;
import at.mrdevelopment.esl.server.provisioning.message.AccessPointProvisioningQueries;
import at.mrdevelopment.esl.server.provisioning.service.ServiceModule;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.SoftwareUpdateModule;
import com.sshtools.ssh.SshException;

public class LancomModulesProvider
implements AccessPointModulesProvider {
    private final LancomDiscoveryModule discoveryModule;
    private final LancomConfigurationModule configModule;
    private final LancomDecisionLogicModule decisionLogicModule;
    private final LancomServiceModule serviceModule;
    private final LancomSettingsCreator settingsCreator;
    private final LancomSoftwareUpdateModule softwareUpdateModule;

    public LancomModulesProvider(AccessPointProvisioningQueries apProvQueries, AccessPointInfoDataset infoDataset) throws SshException {
        this.discoveryModule = new LancomDiscoveryModule(apProvQueries, infoDataset);
        this.configModule = new LancomConfigurationModule();
        this.decisionLogicModule = new LancomDecisionLogicModule();
        this.serviceModule = new LancomServiceModule();
        this.settingsCreator = new LancomSettingsCreator();
        this.softwareUpdateModule = new LancomSoftwareUpdateModule();
    }

    @Override
    public DiscoveryModule getDiscoveryModule() {
        return this.discoveryModule;
    }

    @Override
    public ConfigurationModule getConfigurationModule() {
        return this.configModule;
    }

    @Override
    public DecisionLogicModule getDecisioLogicModule() {
        return this.decisionLogicModule;
    }

    @Override
    public ServiceModule getServiceModule() {
        return this.serviceModule;
    }

    @Override
    public AccessPointType getAccessPointType() {
        return AccessPointType.LANCOM;
    }

    @Override
    public SettingsCreator getSettingsCreator() {
        return this.settingsCreator;
    }

    @Override
    public SoftwareUpdateModule getSoftwareUpdateModule() {
        return this.softwareUpdateModule;
    }
}

