/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.lancom;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.BaseDecisionLogicModule;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.DecisionLogicModule;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.ThinSettings;
import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicFields;
import at.mrdevelopment.esl.server.provisioning.field.ConfigField;
import at.mrdevelopment.esl.server.provisioning.field.ConfigFieldValue;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomConfigHolder;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomFields;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomModuleSettings;
import java.util.Map;

public class LancomDecisionLogicModule
extends BaseDecisionLogicModule
implements DecisionLogicModule {
    private LancomModuleSettings settings;

    @Override
    public boolean isUpdateApplicable(BasicConfigHolder configUpdateGoal, BaseExtConfigHolder currentConfig) {
        return true;
    }

    private boolean innerCanComenOnlineWithCurrentSituation(BasicConfigHolder targetConfig, LancomConfigHolder providedConfig) {
        return !providedConfig.isUdpPortSet() || providedConfig.isSet(LancomFields.WE_PAPER_MODULE_OPERATING) && providedConfig.get(LancomFields.WE_PAPER_MODULE_OPERATING).getBoolValue();
    }

    @Override
    public boolean canComeOnlineWithCurrentSituation(BasicConfigHolder targetConfig, BaseExtConfigHolder providedConfig) {
        boolean isStaticAddressAssigned = targetConfig.isStaticAddressAssigned();
        boolean isStaticAddressEmpty = targetConfig.isStaticAddressEmpty();
        if (isStaticAddressAssigned) {
            for (Map.Entry<ConfigField, ConfigFieldValue> entry : targetConfig.getConfigFields()) {
                if (entry.getKey().equals(BasicFields.HOSTNAME) || this.entriesMatch(entry, providedConfig.getBasicConfig().get(entry.getKey()))) continue;
                return false;
            }
            return this.innerCanComenOnlineWithCurrentSituation(targetConfig, (LancomConfigHolder)providedConfig);
        }
        if (isStaticAddressEmpty) {
            if (targetConfig.anyNotMandatoryAddressFieldSet()) {
                return false;
            }
            if (targetConfig.isSet(BasicFields.WIRELESS_CHANNEL) && !targetConfig.get(BasicFields.WIRELESS_CHANNEL).matches(providedConfig.getBasicConfig().get(BasicFields.WIRELESS_CHANNEL))) {
                return false;
            }
            return this.innerCanComenOnlineWithCurrentSituation(targetConfig, (LancomConfigHolder)providedConfig);
        }
        return false;
    }

    @Override
    public void receive(ModuleSpecificSettings settings) {
        this.settings = (LancomModuleSettings)settings;
    }

    @Override
    public boolean likelyHappenedAfterLastUpdate(long lastUpdateTime, BaseExtConfigHolder newCurrentConfig) {
        return lastUpdateTime + 7000L < newCurrentConfig.getDiscoveryTime();
    }

    @Override
    public boolean didAuthenticationFail(BaseExtConfigHolder providedConfig) {
        LancomConfigHolder temp = (LancomConfigHolder)providedConfig;
        return !temp.wasAuthenticationSuccessful();
    }

    @Override
    public boolean doWeTryInit(BaseExtConfigHolder providedConfig) {
        LancomConfigHolder temp = (LancomConfigHolder)providedConfig;
        return !temp.isUdpPortSet() && !this.settings.getDefaultPassword().equals(this.settings.getPassword());
    }

    @Override
    public boolean isRfModuleWorking(BaseExtConfigHolder providedConfig) {
        LancomConfigHolder temp = (LancomConfigHolder)providedConfig;
        return temp.isOperating();
    }

    @Override
    public boolean commonSettingsChanged() {
        return false;
    }

    @Override
    public boolean isPasswordChangeRequired(BaseExtConfigHolder providedConfig) {
        return !this.settings.getDefaultPassword().equals(this.settings.getPassword());
    }

    @Override
    public boolean isInitAllowed(long lastInitTime) {
        return System.currentTimeMillis() - lastInitTime > (long)Config.getLancomInitRetryIntervalInSeconds() * 1000L;
    }

    @Override
    public boolean accessPointsRequireReinit() {
        return this.settings.accessPointsRequireReinit();
    }

    @Override
    public boolean isOperationModeChangeRequired(ModuleSpecificSettings settings, BaseExtConfigHolder currentConfig) {
        return false;
    }

    @Override
    public boolean isOperationModeChangeSupported(ModuleSpecificSettings settings, AccessPointInfo apInfo) {
        return false;
    }

    @Override
    public ThinSettings getThinConfig() {
        ThinSettings thinConfig = new ThinSettings();
        thinConfig.setThinModeEnabled(this.settings.thinModeEnabled());
        return thinConfig;
    }

    @Override
    public boolean isOutboundModeSupported(AccessPointInfo apInfo) {
        return false;
    }

    @Override
    public boolean isTLSSupported(AccessPointInfo apInfo) {
        return false;
    }

    @Override
    public boolean hasTLSConfigChanged(ModuleSpecificSettings settings, BaseExtConfigHolder currentConfig) {
        return false;
    }
}

