/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.lancom;

import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.configuration.ConfigurationModule;
import at.mrdevelopment.esl.server.provisioning.configuration.OperationResult;
import at.mrdevelopment.esl.server.provisioning.configuration.SuccessState;
import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicFields;
import at.mrdevelopment.esl.server.provisioning.field.ConfigField;
import at.mrdevelopment.esl.server.provisioning.field.ConfigFieldValue;
import at.mrdevelopment.esl.server.provisioning.lancom.ConfigTranslator;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomConfigHolder;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomFields;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomModuleSettings;
import at.mrdevelopment.toolkit.lancom.ConnectResult;
import at.mrdevelopment.toolkit.lancom.LancomConfigClient;
import at.mrdevelopment.toolkit.lancom.LancomConfigInstruction;
import at.mrdevelopment.toolkit.lancom.LancomConfiguration;
import at.mrdevelopment.toolkit.lancom.LancomException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.sshtools.ssh.SshException;

public class LancomConfigurationModule
implements ConfigurationModule {
    private static ESLLogger logger = ESLLogger.getLogger(LancomConfigurationModule.class);
    private volatile boolean running = false;
    private LancomConfigClient client = new LancomConfigClient();
    private LancomModuleSettings settings;

    @Override
    public boolean setup(BaseExtConfigHolder currentConfig) {
        if (logger.isDebugEnabled()) {
            logger.debug("Connecting to " + currentConfig.getBasicConfig().getAddress() + " ...");
        }
        boolean success = true;
        try {
            this.client.setLogin(this.settings.getUsername(), this.settings.getPassword());
            int sshPort = currentConfig.isSet(LancomFields.SSH_PORT) ? currentConfig.get(LancomFields.SSH_PORT).getIntValue() : 22;
            ConnectResult result = this.client.connect(currentConfig.getBasicConfig().getAddress(), sshPort);
            success = result == ConnectResult.SUCCESS;
        }
        catch (LancomException exc) {
            logger.error("Could not connect to %d at %s. Error: %s.", new Object[]{currentConfig.getBasicConfig().getApId(), currentConfig.getBasicConfig().getAddress(), exc.getMessage()});
            success = false;
        }
        return success;
    }

    @Override
    public OperationResult updateAccessPointConfig(BasicConfigHolder configUpdateGoal, BaseExtConfigHolder currentConfig) {
        int commandCount = 0;
        int successCount = 0;
        OperationResult result = new OperationResult();
        LancomConfigHolder configChanges = new LancomConfigHolder(0L);
        boolean updatedNetworkSettings = false;
        if (configUpdateGoal.isSet(BasicFields.IP_ADDRESS) && configUpdateGoal.isSet(BasicFields.SUBNET_MASK) && (!configUpdateGoal.get(BasicFields.IP_ADDRESS).matches(currentConfig.getBasicConfig().get(BasicFields.IP_ADDRESS)) || !configUpdateGoal.get(BasicFields.SUBNET_MASK).matches(currentConfig.getBasicConfig().get(BasicFields.SUBNET_MASK)))) {
            ++commandCount;
            updatedNetworkSettings = true;
            try {
                this.client.sendIPAndSubnetMask(configUpdateGoal.getAddress(), configUpdateGoal.getSubnetMask());
                configChanges.getBasicConfig().set(BasicFields.IP_ADDRESS, configUpdateGoal.getAddress());
                configChanges.getBasicConfig().set(BasicFields.SUBNET_MASK, configUpdateGoal.getSubnetMask());
                ++successCount;
                result.setRequiresServiceReinit(true);
            }
            catch (LancomException exc) {
                result.setState(SuccessState.NOT_SUCCESSFUL);
                return result;
            }
        }
        try {
            this.client.turnOffWePaper();
        }
        catch (LancomException ioe) {
            logger.error("Could not turn OFF WePaper module for AP: %d. Error: %s", new Object[]{configUpdateGoal.getApId(), ioe.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)ioe);
            result.setState(SuccessState.NOT_SUCCESSFUL);
            return result;
        }
        for (ConfigField field : BasicFields.FIELDS) {
            if (field.equals(BasicFields.AP_ID) || field.equals(BasicFields.IP_ADDRESS) || field.equals(BasicFields.SUBNET_MASK) || field.equals(BasicFields.HOSTNAME)) continue;
            logger.debug("next field: " + field.getFieldName());
            if (!configUpdateGoal.isSet(field) || configUpdateGoal.get(field).matches(currentConfig.getBasicConfig().get(field))) continue;
            if (field.equals(BasicFields.GATEWAY_ADDRESS) || field.equals(BasicFields.DNS_ADDRESS)) {
                updatedNetworkSettings = true;
            }
            ++commandCount;
            try {
                this.sendField(field, configUpdateGoal.get(field));
                configChanges.getBasicConfig().set(field, configUpdateGoal.get(field).getValue());
                ++successCount;
                if (!field.equals(BasicFields.PORT)) continue;
                result.setRequiresServiceReinit(true);
            }
            catch (LancomException exc) {
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                result.setState(SuccessState.PARTIALLY_SUCCESSFUL);
            }
        }
        if (commandCount == successCount) {
            try {
                this.client.turnOnWePaper();
                result.setState(SuccessState.SUCCESSFUL);
            }
            catch (LancomException exc) {
                logger.error("Could not turn ON WePaper module for AP: %d. Error: %s.", new Object[]{configUpdateGoal.getApId(), exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                result.setState(SuccessState.NOT_SUCCESSFUL);
            }
        } else {
            result.setState(successCount > 0 ? SuccessState.SUCCESSFUL : SuccessState.NOT_SUCCESSFUL);
        }
        if (updatedNetworkSettings) {
            try {
                this.client.reboot();
            }
            catch (LancomException ioe) {
                logger.error("Could not reboot AP: %d. Error: %s.", new Object[]{configUpdateGoal.getApId(), ioe.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)ioe);
                result.setState(SuccessState.NOT_SUCCESSFUL);
            }
        }
        result.setExtHolder(configChanges);
        this.client.disconnect();
        return result;
    }

    private void sendField(ConfigField field, ConfigFieldValue value) throws LancomException {
        LancomConfigInstruction instruction;
        if (logger.isDebugEnabled()) {
            logger.debug(field.getFieldName() + " should be set to: " + value.getValue().toString());
        }
        if ((instruction = LancomConfigInstruction.createFromString((String)field.getFieldName())) != null) {
            this.client.sendInstruction(instruction, value.getValue().toString());
        } else {
            logger.debug("No known instruction or not possible to set %s, skipping...", new Object[]{field.getFieldName()});
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void start() {
        this.running = true;
    }

    @Override
    public void stop() {
        this.running = false;
    }

    @Override
    public void receive(ModuleSpecificSettings newSettings) {
        if (newSettings instanceof LancomModuleSettings) {
            this.settings = (LancomModuleSettings)newSettings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult initAccessPoint(BaseExtConfigHolder currentConfig) {
        OperationResult result = new OperationResult();
        try {
            LancomConfiguration lancomConfig = new LancomConfiguration();
            this.client.setLogin(this.settings.getDefaultUsername(), this.settings.getDefaultPassword());
            ConnectResult conResult = this.client.connect(currentConfig.getBasicConfig().getAddress(), currentConfig.get(LancomFields.SSH_PORT).getIntValue());
            if (conResult == ConnectResult.SUCCESS) {
                if (this.client.initAndCompleteConfig(lancomConfig, this.settings.getPassword(), this.settings.getDefaultPassword(), this.settings.usernameIsDefault())) {
                    LancomConfigHolder configUpdate = ConfigTranslator.fromLancomToCommon(lancomConfig);
                    if (configUpdate.isOperating()) {
                        result.setState(SuccessState.SUCCESSFUL);
                        result.setExtHolder(configUpdate);
                    }
                    configUpdate.set(LancomFields.AUTHENTICATION_SUCCESSFUL, true);
                } else {
                    logger.error("Could not init AP = %d at %s. Most likely not able to change password.", new Object[]{currentConfig.getBasicConfig().getApId(), currentConfig.getBasicConfig().getAddress()});
                }
            } else {
                logger.error("Could not init AP = %d at %s. Could not connect.", new Object[]{currentConfig.getBasicConfig().getApId(), currentConfig.getBasicConfig().getAddress()});
            }
        }
        catch (LancomException exc) {
            logger.error("Could not init AP = %d at %s. Error: %s.", new Object[]{currentConfig.getBasicConfig().getApId(), currentConfig.getBasicConfig().getAddress(), exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
        finally {
            this.client.disconnect();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult turnOnRfModule(BaseExtConfigHolder currentConfig) {
        OperationResult result = new OperationResult();
        try {
            this.client.setLogin(this.settings.getUsername(), this.settings.getPassword());
            ConnectResult conResult = this.client.connect(currentConfig.getBasicConfig().getAddress(), currentConfig.get(LancomFields.SSH_PORT).getIntValue());
            if (conResult == ConnectResult.SUCCESS) {
                boolean success = this.client.turnOnWePaper();
                LancomConfigHolder configUpdate = new LancomConfigHolder(0L);
                configUpdate.set(LancomFields.WE_PAPER_MODULE_OPERATING, success);
                if (success) {
                    result.setState(SuccessState.SUCCESSFUL);
                    result.setExtHolder(configUpdate);
                } else {
                    logger.error("Could not turn on HF module for AP = %d at %s. Operation failed.", new Object[]{currentConfig.getBasicConfig().getApId(), currentConfig.getBasicConfig().getAddress()});
                }
            } else {
                logger.error("Could not turn on HF module for AP = %d at %s. Could not connect.", new Object[]{currentConfig.getBasicConfig().getApId(), currentConfig.getBasicConfig().getAddress()});
            }
        }
        catch (LancomException exc) {
            logger.error("Could not turn on HF module for AP = %d at %s. Error: %s.", new Object[]{currentConfig.getBasicConfig().getApId(), currentConfig.getBasicConfig().getAddress(), exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
        finally {
            this.client.disconnect();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult changePassword(BaseExtConfigHolder currentConfig) {
        OperationResult result = new OperationResult();
        try {
            if (this.settings.usernameIsDefault()) {
                this.client.setLogin(this.settings.getDefaultUsername(), this.settings.getDefaultPassword());
                ConnectResult conResult = this.client.connect(currentConfig.getBasicConfig().getAddress(), currentConfig.get(LancomFields.SSH_PORT).getIntValue());
                if (conResult == ConnectResult.SUCCESS) {
                    boolean success = this.client.changePassword(this.settings.getPassword(), this.settings.getDefaultPassword());
                    if (success) {
                        result.setState(SuccessState.SUCCESSFUL);
                    } else {
                        logger.error("Could not change password on AP = %d at %s. Operation failed.", new Object[]{currentConfig.getBasicConfig().getApId(), currentConfig.getBasicConfig().getAddress()});
                    }
                } else {
                    logger.error("Could not change password on AP = %d at %s. Could not connect.", new Object[]{currentConfig.getBasicConfig().getApId(), currentConfig.getBasicConfig().getAddress()});
                }
            }
        }
        catch (LancomException exc) {
            logger.error("Could not change password on AP = %d at %s. Error: %s.", new Object[]{currentConfig.getBasicConfig().getApId(), currentConfig.getBasicConfig().getAddress(), exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
        finally {
            if (this.client.isConnected()) {
                this.client.disconnect();
            }
        }
        return result;
    }

    @Override
    public OperationResult changeOperationMode(ModuleSpecificSettings settings, BaseExtConfigHolder currentConfig) {
        return new OperationResult();
    }

    @Override
    public OperationResult changeOperationMode(ModuleSpecificSettings settings, BasicConfigHolder configUpdateGoal) {
        OperationResult result = new OperationResult();
        return result;
    }

    @Override
    public void init(boolean sslEnabled) {
    }
}

