/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.lancom;

import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.server.provisioning.field.BaseConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicFields;
import at.mrdevelopment.esl.server.provisioning.field.ConfigField;
import at.mrdevelopment.esl.server.provisioning.field.ConfigFieldType;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomConfigHolder;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomFields;
import at.mrdevelopment.toolkit.lancom.ConnectResult;
import at.mrdevelopment.toolkit.lancom.LancomConfigOption;
import at.mrdevelopment.toolkit.lancom.LancomConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class ConfigTranslator {
    private static Map<ConfigField, LancomConfigOption> field2OptionMapping = new HashMap<ConfigField, LancomConfigOption>();

    private static Object getValue(ConfigFieldType type, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            switch (type) {
                case BOOL: {
                    return Boolean.parseBoolean(value);
                }
                case CHANNEL: {
                    return WirelessChannel.fromLancomFrequencies((String)value);
                }
                case INTEGER: {
                    return Integer.parseInt(value);
                }
            }
            return value;
        }
        return null;
    }

    private static String transform(LancomConfigOption lco, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            if (lco == LancomConfigOption.WIRELESS_E_PAPER_OPERATING) {
                return BooleanUtils.toStringTrueFalse((boolean)"Manual".equals(value));
            }
            if (lco == LancomConfigOption.AUTHENTICATION_RESULT) {
                return BooleanUtils.toStringTrueFalse((ConnectResult.SUCCESS.name().equals(value) || ConnectResult.OTHER_ERROR.name().equals(value) ? 1 : 0) != 0);
            }
            return value;
        }
        return null;
    }

    private static void checkForAndSet(List<ConfigField> fields, LancomConfiguration sourceConfig, BaseConfigHolder targetConfig) {
        for (ConfigField cf : fields) {
            Object value;
            LancomConfigOption lco = field2OptionMapping.get(cf);
            if (lco == null || (value = ConfigTranslator.getValue(cf.getType(), ConfigTranslator.transform(lco, sourceConfig.get(lco)))) == null) continue;
            if (cf.equals(BasicFields.PORT)) {
                if ((Integer)value < 0) continue;
                targetConfig.set(cf, value);
                continue;
            }
            targetConfig.set(cf, value);
        }
    }

    public static LancomConfigHolder fromLancomToCommon(LancomConfiguration lancomConfig) {
        LancomConfigHolder commonConfig = new LancomConfigHolder(lancomConfig.getDiscoveryTime());
        ConfigTranslator.checkForAndSet(LancomFields.FIELDS, lancomConfig, commonConfig);
        ConfigTranslator.checkForAndSet(BasicFields.FIELDS, lancomConfig, commonConfig.getBasicConfig());
        return commonConfig;
    }

    static {
        field2OptionMapping.put(BasicFields.AP_ID, LancomConfigOption.AP_ID);
        field2OptionMapping.put(BasicFields.IP_ADDRESS, LancomConfigOption.IP_ADDRESS);
        field2OptionMapping.put(BasicFields.SUBNET_MASK, LancomConfigOption.SUBNET_MASK);
        field2OptionMapping.put(BasicFields.GATEWAY_ADDRESS, LancomConfigOption.GATEWAY_ADDRESS);
        field2OptionMapping.put(BasicFields.DNS_ADDRESS, LancomConfigOption.DNS_ADDRESS);
        field2OptionMapping.put(BasicFields.WIRELESS_CHANNEL, LancomConfigOption.WIRELESS_CHANNEL);
        field2OptionMapping.put(BasicFields.PORT, LancomConfigOption.WIRELESS_E_PAPER_PORT);
        field2OptionMapping.put(LancomFields.SERIAL_NUMBER, LancomConfigOption.SERIAL_NUMBER);
        field2OptionMapping.put(LancomFields.CONTROLLER_IP, LancomConfigOption.CONTROLLER_IP);
        field2OptionMapping.put(LancomFields.SSH_PORT, LancomConfigOption.SSH_PORT);
        field2OptionMapping.put(LancomFields.HTTP_PORT, LancomConfigOption.HTTP_PORT);
        field2OptionMapping.put(LancomFields.HTTPS_PORT, LancomConfigOption.HTTPS_PORT);
        field2OptionMapping.put(LancomFields.WE_PAPER_MODULE_OPERATING, LancomConfigOption.WIRELESS_E_PAPER_OPERATING);
        field2OptionMapping.put(LancomFields.AUTHENTICATION_SUCCESSFUL, LancomConfigOption.AUTHENTICATION_RESULT);
    }
}

