/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.imagotag;

import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceClient;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.persistence.record.AccessPointUpdatePackageRecord;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.situation.AccessPointConfigSituation;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.SoftwareUpdate;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.SoftwareUpdateException;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.SoftwareUpdateModule;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.WebserviceException;

public class ImagotagSoftwareUpdateModule
implements SoftwareUpdateModule {
    private final AccessPointInfoDataset infoDataset;

    public ImagotagSoftwareUpdateModule(AccessPointInfoDataset infoDataset) {
        this.infoDataset = infoDataset;
    }

    @Override
    public void sendSoftwareUpdate(AccessPointConfigSituation accessPointConfigSituation, SoftwareUpdate softwareUpdate) throws SoftwareUpdateException {
        AccessPointUpdatePackageRecord updatePackage = softwareUpdate.getUpdatePackage();
        AccessPointService service = this.infoDataset.getService(softwareUpdate.getAccessPointId());
        try {
            if (service == null) {
                throw new SoftwareUpdateException("No service client available to send update package %s to access point %d.", updatePackage.getIdentifier(), softwareUpdate.getAccessPointId());
            }
            ServiceAddress serviceAddress = service.getSoftwareUpdateServiceAddress();
            ServiceAddress newServiceAddress = new ServiceAddress(serviceAddress.getProtocol(), serviceAddress.getHost(), serviceAddress.getPort(), "admin", Config.getAccessPointAdministrationPassword(), serviceAddress.getPath());
            AccessPointServiceClient administrationService = new AccessPointServiceClient(softwareUpdate.getAccessPointId().intValue(), newServiceAddress, this.infoDataset.getHttpConfiguration(), false, false);
            administrationService.sendSoftwareUpdate(updatePackage.getUpdatePackageFile());
        }
        catch (WebserviceException exc) {
            throw new SoftwareUpdateException(exc, "Could not send update package %s to access point %d: %s", updatePackage.getIdentifier(), softwareUpdate.getAccessPointId(), exc.getMessage());
        }
        catch (InitializationException exc) {
            throw new SoftwareUpdateException(exc, "Could not send update package %s to access point %d: %s", updatePackage.getIdentifier(), softwareUpdate.getAccessPointId(), exc.getMessage());
        }
    }

    @Override
    public void receive(ModuleSpecificSettings settings) {
    }
}

