/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.imagotag;

import at.mrdevelopment.esl.admin.AccessPointConfigurationXMLSerializer;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AccessPointConfiguration;
import at.mrdevelopment.esl.certificate.ESLKeyManagerFactory;
import at.mrdevelopment.esl.certificate.ESLTrustManager;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.http.HttpServiceClient;
import at.mrdevelopment.toolkit.http.HttpServiceClientConfiguration;
import at.mrdevelopment.toolkit.http.IgnoreResponseHandler;
import at.mrdevelopment.toolkit.http.ResponseHandler;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.http.XMLContentProducerFactory;
import at.mrdevelopment.toolkit.xml.SerializeException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.EntityTemplate;
import org.w3c.dom.Document;

public class ImagotagAccessPointConfigClient
implements Shutdownable {
    private final HttpServiceClient httpServiceClient;
    private final AccessPointConfigurationXMLSerializer xmlAccessPointConfiguration;
    private final XMLContentProducerFactory contentProducerFactory;

    ImagotagAccessPointConfigClient(ServiceAddress serviceAddress) throws InitializationException {
        this.httpServiceClient = new HttpServiceClient(serviceAddress.getHost(), serviceAddress.getPort(), serviceAddress.useSSL(), serviceAddress.getPath(), this.getHttpConfiguration(), false);
        if (serviceAddress.hasCredentials()) {
            this.httpServiceClient.setCredentials(serviceAddress.getUsername(), serviceAddress.getPassword());
        }
        this.xmlAccessPointConfiguration = new AccessPointConfigurationXMLSerializer();
        this.contentProducerFactory = XMLContentProducerFactory.newInstance();
    }

    void sendConfiguration(AccessPointConfiguration accessPointConfiguration) throws WebserviceException, SerializeException {
        Document document = this.xmlAccessPointConfiguration.toXML(accessPointConfiguration);
        HttpPost request = new HttpPost("/service/config/all.xml");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new IgnoreResponseHandler());
    }

    void sendOperationMode(boolean thinAPModeEnabled, boolean outboundModeEnabled, String apcAddress, int apcPort, boolean tlsEnabled) throws WebserviceException, SerializeException {
        Document document = this.xmlAccessPointConfiguration.toThinModeXML(thinAPModeEnabled, outboundModeEnabled, apcAddress, apcPort, tlsEnabled);
        HttpPost request = new HttpPost("/service/config/thinApMode.xml");
        request.setEntity((HttpEntity)new EntityTemplate(this.contentProducerFactory.createContentProducer(document)));
        this.httpServiceClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new IgnoreResponseHandler());
    }

    public void shutdown() {
        this.httpServiceClient.close();
    }

    private HttpServiceClientConfiguration getHttpConfiguration() throws InitializationException {
        return HttpServiceClientConfiguration.createConfiguration(null, (X509TrustManager)new ESLTrustManager(Config.isSslStrictVerification(), Config.isSslClientCertificates()), (KeyManager[])new ESLKeyManagerFactory().getKeyManagers(), (boolean)Config.isSslHostnameVerification());
    }
}

