/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.imagotag;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.server.MSPConfigurationBuilder;
import at.mrdevelopment.esl.server.provisioning.field.BaseConfigHolder;
import at.mrdevelopment.esl.server.provisioning.imagotag.CommonFields;

public class CommonConfigHolder
extends BaseConfigHolder {
    CommonConfigHolder(EnvironmentProperties env, boolean thinModeEnabled) {
        super(CommonFields.FIELDS);
        this.set(CommonFields.TIME_SYNC_ENABLED, Config.isTimesyncEnabled());
        this.set(CommonFields.TIME_SERVER, Config.getTimeServer());
        this.set(CommonFields.TIME_SYNC_UPDATE_INTERVAL_IN_MINUTES, Config.getTimesyncUpdateIntervalInMinutes());
        this.set(CommonFields.BROADCAST_ENABLED, Config.isBroadcastEnabled());
        this.set(CommonFields.BROADCAST_INTERVAL_IN_MIUTES, Config.getBroadcastIntervalInMinutes());
        this.set(CommonFields.BROADCAST_PORT, Config.getBroadcastPort());
        this.set(CommonFields.LOG_LEVEL, Config.getLogLevel());
        this.set(CommonFields.LOG_REMOTE_ENABLED, Config.isLogSocketAppenderEnabled());
        this.set(CommonFields.LOG_REMOTE_ADDRESS, Config.getLogSocketAppenderRemoteAddress());
        this.set(CommonFields.LOG_REMOTE_PORT, Config.getLogSocketAppenderPort());
        this.set(CommonFields.MSP_RELAY_HOST, MSPConfigurationBuilder.getMspRelayHost(env));
        this.set(CommonFields.MSP_RELAY_PORT, Config.getMspRelayPort());
        this.set(CommonFields.MSP_USER, Config.getMspUser());
        this.set(CommonFields.MSP_PASSWORD, Config.getMspPassword());
        this.set(CommonFields.MSP_DISCOVERY_PATH, Config.getMspDiscoveryPath());
        this.set(CommonFields.MSP_UPLOAD_INTERVAL_IN_MINUTES, Config.getMspUploadIntervalInMinutes());
        this.set(CommonFields.MSP_ENABLED, Config.isMspIntegrationEnabledOnAccessPoint());
        this.set(CommonFields.USE_THIN_MODE, thinModeEnabled);
        boolean useThinSsl = Config.isAccessPointSsl();
        this.set(CommonFields.USE_THIN_SSL, useThinSsl);
        if (thinModeEnabled) {
            boolean outboundMode = Config.isAccessPointThinUseOutboundMode();
            this.set(CommonFields.USE_OUTBOUND_MODE, outboundMode);
            if (outboundMode) {
                this.set(CommonFields.APC_ADDRESS, Config.getAccessPointThinControllerAddress());
                int port = -1;
                if (useThinSsl) {
                    port = Config.getAccessPointThinControllerTLSPort();
                    if (port < 0) {
                        port = 7354;
                    }
                } else {
                    port = Config.getAccessPointThinControllerPort();
                    if (port < 0) {
                        port = 7353;
                    }
                }
                this.set(CommonFields.APC_PORT, port);
            } else {
                this.set(CommonFields.APC_ADDRESS, "");
                this.set(CommonFields.APC_PORT, -1);
            }
        } else {
            this.set(CommonFields.USE_OUTBOUND_MODE, false);
            this.set(CommonFields.APC_ADDRESS, "");
            this.set(CommonFields.APC_PORT, -1);
        }
    }
}

