/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.field;

import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.server.provisioning.field.ConfigFieldType;
import org.apache.commons.lang.StringUtils;

public class ConfigFieldValue {
    private Object value;
    private ConfigFieldType type;

    protected ConfigFieldValue(ConfigFieldType type) {
        this.type = type;
    }

    protected ConfigFieldValue(ConfigFieldType type, Object value) {
        this.type = type;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public int getIntValue() {
        return (Integer)this.value;
    }

    public boolean getBoolValue() {
        return (Boolean)this.value;
    }

    public String getStringValue() {
        return (String)this.value;
    }

    public WirelessChannel getWirelessChannel() {
        return (WirelessChannel)this.value;
    }

    protected void setValue(Object value) {
        this.value = value;
    }

    public ConfigFieldType getType() {
        return this.type;
    }

    public boolean isSet() {
        if (this.type == ConfigFieldType.STRING) {
            return StringUtils.isNotBlank((String)((String)this.value));
        }
        return this.value != null;
    }

    public boolean matches(ConfigFieldValue cfv) {
        return this.value.equals(cfv.value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ConfigFieldValue [value=");
        builder.append(this.value);
        builder.append("]");
        return builder.toString();
    }
}

