/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.field;

import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.persistence.record.AccessPointConfiguration;
import at.mrdevelopment.esl.server.provisioning.field.BaseConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicFields;

public class BasicConfigHolder
extends BaseConfigHolder {
    private boolean isNew;
    private boolean autoConfig;

    public BasicConfigHolder() {
        super(BasicFields.FIELDS);
        this.isNew = true;
        this.autoConfig = true;
    }

    private BasicConfigHolder(BasicConfigHolder from) {
        super(BasicFields.FIELDS);
        this.isNew = from.isNew;
        this.autoConfig = from.autoConfig;
        super.transferFrom(from);
    }

    public BasicConfigHolder copy() {
        return new BasicConfigHolder(this);
    }

    public boolean allNonApIdFieldsNotSet() {
        return this.isStaticAddressEmpty() && !this.anyNotMandatoryAddressFieldSet() && !this.isSet(BasicFields.WIRELESS_CHANNEL) && !this.isSet(BasicFields.PORT);
    }

    public boolean isStaticAddressAssigned() {
        return this.isSet(BasicFields.IP_ADDRESS) && this.isSet(BasicFields.SUBNET_MASK);
    }

    public boolean isStaticAddressEmpty() {
        return !this.isSet(BasicFields.IP_ADDRESS) && !this.isSet(BasicFields.SUBNET_MASK);
    }

    public boolean anyNotMandatoryAddressFieldSet() {
        return this.isSet(BasicFields.GATEWAY_ADDRESS) || this.isSet(BasicFields.DNS_ADDRESS);
    }

    public int getApId() {
        return this.get(BasicFields.AP_ID).getIntValue();
    }

    public void setApId(int apId) {
        this.set(BasicFields.AP_ID, apId);
    }

    public boolean isAutoConfig() {
        return this.autoConfig;
    }

    public void setAutoConfig(boolean autoConfig) {
        this.autoConfig = autoConfig;
    }

    public WirelessChannel getWirelessChannel() {
        return this.get(BasicFields.WIRELESS_CHANNEL).getWirelessChannel();
    }

    public void setWirelessChannel(WirelessChannel channel) {
        this.set(BasicFields.WIRELESS_CHANNEL, channel);
    }

    public String getHostname() {
        return this.get(BasicFields.HOSTNAME).getStringValue();
    }

    public void setHostname(String hostname) {
        this.set(BasicFields.HOSTNAME, hostname);
    }

    public String getAddress() {
        return this.get(BasicFields.IP_ADDRESS).getStringValue();
    }

    public void setAddress(String address) {
        this.set(BasicFields.IP_ADDRESS, address);
    }

    public String getSubnetMask() {
        return this.get(BasicFields.SUBNET_MASK).getStringValue();
    }

    public void setSubnetMask(String subnetMask) {
        this.set(BasicFields.SUBNET_MASK, subnetMask);
    }

    public String getGatewayAddress() {
        return this.get(BasicFields.GATEWAY_ADDRESS).getStringValue();
    }

    public void setGatewayAddress(String address) {
        this.set(BasicFields.GATEWAY_ADDRESS, address);
    }

    public String getDnsAddress() {
        return this.get(BasicFields.DNS_ADDRESS).getStringValue();
    }

    public void setDnsAddress(String address) {
        this.set(BasicFields.DNS_ADDRESS, address);
    }

    public int getPort() {
        return this.get(BasicFields.PORT).getIntValue();
    }

    public void setPort(int port) {
        this.set(BasicFields.PORT, port);
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setToOld() {
        this.isNew = false;
    }

    void setToNew() {
        this.isNew = true;
    }

    public static BasicConfigHolder createFrom(AccessPointConfiguration apc) {
        BasicConfigHolder newConfigHolder = new BasicConfigHolder();
        newConfigHolder.setApId(apc.getAccessPointId());
        newConfigHolder.setAutoConfig(apc.isAutoConfig());
        newConfigHolder.setWirelessChannel(apc.getChannel());
        newConfigHolder.setAddress(apc.getAddress());
        newConfigHolder.setSubnetMask(apc.getSubnetMask());
        newConfigHolder.setGatewayAddress(apc.getGateway());
        newConfigHolder.setDnsAddress(apc.getDns());
        newConfigHolder.setHostname(apc.getHostName());
        if (apc.getPort() >= 0) {
            newConfigHolder.setPort(apc.getPort());
        }
        return newConfigHolder;
    }
}

