/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.field;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.server.provisioning.field.BaseConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.ConfigField;
import at.mrdevelopment.esl.server.provisioning.field.Difference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class BaseExtConfigHolder
extends BaseConfigHolder {
    protected BasicConfigHolder basicConfig = new BasicConfigHolder();
    protected long discoveryTimeInMillis;

    protected BaseExtConfigHolder(List<ConfigField> fields, long discoveryTimeInMillis) {
        super(fields);
        this.discoveryTimeInMillis = discoveryTimeInMillis;
    }

    protected void transferFrom(BaseExtConfigHolder other) {
        this.basicConfig.transferFrom(other.basicConfig);
        super.transferFrom(other);
    }

    protected void overtake(BaseExtConfigHolder from, Collection<ConfigField> fieldsToIgnore) {
        this.basicConfig.overtake(from.basicConfig, fieldsToIgnore);
        this.basicConfig.setToNew();
        super.overtake(from, fieldsToIgnore);
    }

    @Override
    protected void overtake(BaseConfigHolder from, Collection<ConfigField> fieldsToIgnore) {
        this.basicConfig.overtake(from, fieldsToIgnore);
    }

    public abstract BaseExtConfigHolder copy();

    public abstract void customOvertake(BaseExtConfigHolder var1);

    public final BasicConfigHolder getBasicConfig() {
        return this.basicConfig;
    }

    public final long getDiscoveryTime() {
        return this.discoveryTimeInMillis;
    }

    public final void setDiscoveryTime(long time) {
        this.discoveryTimeInMillis = time;
    }

    public final void regularOvertake(BaseExtConfigHolder from) {
        this.overtake(from, Collections.<ConfigField>emptyList());
    }

    public boolean hasExpired(long currentTimeInMillis) {
        return currentTimeInMillis > this.discoveryTimeInMillis + (long)Config.getAccessPointDiscoveredDataTimeout() * 60L * 1000L;
    }

    @Override
    public final void regularOvertake(BaseConfigHolder from) {
        this.overtake(from, Collections.<ConfigField>emptyList());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BaseExtConfigHolder [basicConfig=");
        builder.append(this.basicConfig);
        builder.append(", configFields=");
        builder.append(this.configFields);
        builder.append("]");
        return builder.toString();
    }

    public abstract Difference isDifferentFrom(BaseExtConfigHolder var1);

    public Difference isDifferentFrom(BaseExtConfigHolder other, Collection<ConfigField> fieldsToIgnore) {
        return new Difference(this.basicConfig.isDifferentFrom(other.basicConfig, fieldsToIgnore), super.isDifferentFrom(other, fieldsToIgnore));
    }
}

