/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.decisionlogic;

import at.mrdevelopment.esl.server.provisioning.decisionlogic.DecisionLogicModule;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.DecisionMode;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.TargetConfigValidity;
import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicFields;
import at.mrdevelopment.esl.server.provisioning.field.ConfigField;
import at.mrdevelopment.esl.server.provisioning.field.ConfigFieldValue;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagFields;
import java.util.Map;

public abstract class BaseDecisionLogicModule
implements DecisionLogicModule {
    @Override
    public boolean isUpdateApplicable(BasicConfigHolder configUpdateGoal, BaseExtConfigHolder currentConfig) {
        if (currentConfig == null) {
            return false;
        }
        ConfigFieldValue cfv = currentConfig.get(ImagotagFields.AUTO_CONFIG_ENABLED);
        return cfv.isSet() ? cfv.getBoolValue() : false;
    }

    protected boolean doesProvidedNeedUpdateFor(ConfigFieldValue targetCfv, ConfigFieldValue providedCfv) {
        return targetCfv.isSet() ? !targetCfv.matches(providedCfv) : false;
    }

    @Override
    public TargetConfigValidity getValidity(BasicConfigHolder targetConfig, DecisionMode mode) {
        if (!targetConfig.isSet(BasicFields.AP_ID)) {
            return TargetConfigValidity.NOT_VALID;
        }
        if (mode == DecisionMode.CENTRALIZED) {
            boolean isStaticAddressAssigned = targetConfig.isStaticAddressAssigned();
            boolean isStaticAddressEmpty = targetConfig.isStaticAddressEmpty();
            if (isStaticAddressAssigned) {
                return TargetConfigValidity.CENTRALIZED_BASIC;
            }
            if (isStaticAddressEmpty) {
                return !targetConfig.anyNotMandatoryAddressFieldSet() ? TargetConfigValidity.CENTRALIZED_CHANNEL_OR_NOT : TargetConfigValidity.NOT_VALID;
            }
            return TargetConfigValidity.NOT_VALID;
        }
        if (targetConfig.allNonApIdFieldsNotSet()) {
            return TargetConfigValidity.MANUAL_ID_ONLY;
        }
        if (targetConfig.isSet(BasicFields.IP_ADDRESS) && targetConfig.isSet(BasicFields.PORT)) {
            return TargetConfigValidity.MANUAL_BASIC;
        }
        return TargetConfigValidity.NOT_VALID;
    }

    protected boolean entriesMatch(Map.Entry<ConfigField, ConfigFieldValue> entry, ConfigFieldValue other) {
        ConfigFieldValue cfv = entry.getValue();
        return !cfv.isSet() || cfv.matches(other);
    }

    @Override
    public boolean canComeOnlineWithCurrentSituation(BasicConfigHolder targetConfig, BaseExtConfigHolder providedConfig) {
        boolean isStaticAddressAssigned = targetConfig.isStaticAddressAssigned();
        boolean isStaticAddressEmpty = targetConfig.isStaticAddressEmpty();
        if (isStaticAddressAssigned) {
            for (Map.Entry<ConfigField, ConfigFieldValue> entry : targetConfig.getConfigFields()) {
                if (entry.getKey().equals(BasicFields.PORT) || this.entriesMatch(entry, providedConfig.getBasicConfig().get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
        if (isStaticAddressEmpty) {
            if (targetConfig.anyNotMandatoryAddressFieldSet()) {
                return false;
            }
            return !targetConfig.isSet(BasicFields.WIRELESS_CHANNEL) || targetConfig.get(BasicFields.WIRELESS_CHANNEL).matches(providedConfig.getBasicConfig().get(BasicFields.WIRELESS_CHANNEL));
        }
        return false;
    }
}

