/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.util.AccessPointUpdate;
import at.mrdevelopment.esl.server.provisioning.Status;
import at.mrdevelopment.esl.server.provisioning.message.AccessPointProvisioningQueries;
import at.mrdevelopment.esl.server.provisioning.resolution.SituationResolution;
import at.mrdevelopment.esl.server.provisioning.situation.AccessPointConfigSituation;
import at.mrdevelopment.toolkit.log.ESLLogger;

public class ProvisioningSituationHelper {
    private static final String LOG_ONLINE = "AP %d went ONLINE, config-type %s, with resolution %s.";
    private static final String LOG_OFFLINE = "AP %d went OFFLINE, config-type %s, with resolution %s.";
    private final ESLLogger logger;
    private final AccessPointInfoDataset infoDataset;
    private final AccessPointProvisioningQueries apProvisioningQueries;

    public ProvisioningSituationHelper(ESLLogger logger, AccessPointInfoDataset infoDataset, AccessPointProvisioningQueries apProvisioningQueries) {
        this.logger = logger;
        this.infoDataset = infoDataset;
        this.apProvisioningQueries = apProvisioningQueries;
    }

    boolean mustChangeToOffline(AccessPointConfigSituation situation) {
        return situation.didBasicCurrentConfigChange() || situation.lastStatus() == Status.UNKNOWN || situation.lastStatus() == Status.ONLINE;
    }

    boolean mustChangeToOnline(AccessPointConfigSituation situation) {
        return situation.didBasicCurrentConfigChange() || situation.lastStatus() == Status.UNKNOWN || situation.lastStatus() == Status.OFFLINE || situation.context().wasUpdateSuccessful() && situation.context().updateRequiresReinit() || situation.accessPointsRequireReinit();
    }

    void goOffline(AccessPointConfigSituation situation, EnvironmentProperties env, SituationResolution resolution) {
        if (this.mustChangeToOffline(situation)) {
            situation.setOffline();
            situation.makeAccessPointServiceGoOffline(this.infoDataset, env);
            this.logOffline(situation, resolution);
        }
    }

    void logOffline(AccessPointConfigSituation situation, SituationResolution resolution) {
        this.apProvisioningQueries.setProblem(resolution.getProblem(), situation.getApId());
        this.logger.info(LOG_OFFLINE, new Object[]{situation.getApId(), resolution.getConfigType(), resolution.getDescription()});
    }

    void logOnline(AccessPointConfigSituation situation, SituationResolution resolution) {
        this.apProvisioningQueries.unsetProblem(situation.getApId());
        this.logger.info(LOG_ONLINE, new Object[]{situation.getApId(), resolution.getConfigType(), resolution.getDescription()});
    }

    void goOnline(AccessPointConfigSituation situation, EnvironmentProperties env, SituationResolution resolution) {
        if (this.mustChangeToOnline(situation)) {
            situation.setOnline();
            AccessPointUpdate.Builder builder = new AccessPointUpdate.Builder();
            builder.accessPointId(situation.getApId()).serviceAddress(situation.createServiceAddress(env));
            builder.isPermanentlyOffline(false).serviceToBeInitialized(false).autoConfig(situation.canUpdate());
            builder.thinMode(situation.isThinModeEnabled());
            this.infoDataset.updateAccessPoint(builder.build());
            this.logOnline(situation, resolution);
        }
    }

    void situationOnlineOfflineLogic(AccessPointConfigSituation situation, SituationResolution resolution, EnvironmentProperties env) {
        if (situation.canComeOnlineWithCurrentSituation()) {
            this.goOnline(situation, env, resolution);
        } else {
            this.goOffline(situation, env, resolution);
        }
    }
}

