/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.admin.platform.EnvironmentPropertiesHelper;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.TransactionalESLProcessingTask;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.AccessPointConfigurationDataset;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.server.provisioning.AccessPointModulesProvider;
import at.mrdevelopment.esl.server.provisioning.AccessPointTypeModules;
import at.mrdevelopment.esl.server.provisioning.DiscoveryModuleProcessing;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.SituationOperationModeProcessing;
import at.mrdevelopment.esl.server.provisioning.SituationsUpdateProcessing;
import at.mrdevelopment.esl.server.provisioning.discovery.DiscoveryMode;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomModulesProvider;
import at.mrdevelopment.esl.server.provisioning.message.AccessPointProvisioningQueries;
import at.mrdevelopment.esl.server.provisioning.simulated.SimulatedModulesProvider;
import at.mrdevelopment.esl.server.provisioning.simulatedthinap.SimulatedThinApModulesProvider;
import at.mrdevelopment.esl.server.provisioning.situation.AccessPointConfigSituation;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.AccessPointSoftwareUpdateProcessing;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.HashMap;

public class ProvisioningModule
extends TransactionalESLProcessingTask
implements Shutdownable {
    private static final ESLLogger logger = ESLLogger.getLogger(ProvisioningModule.class);
    private final HashMap<AccessPointType, AccessPointTypeModules> apType2ModulesMapping = new HashMap();
    private final HashMap<Integer, AccessPointConfigSituation> apConfigMapping = new HashMap();
    private final AccessPointConfigurationDataset configDataset;
    private final AccessPointInfoDataset infoDataset;
    private final DiscoveryModuleProcessing discoveryProcessing;
    private final SituationsUpdateProcessing situationProcessing;
    private final AccessPointSoftwareUpdateProcessing softwareUpdateProcessing;

    public ProvisioningModule(TransactionSupplier transactionSupplier, AccessPointConfigurationDataset configDataset, AccessPointInfoDataset infoDataset, AccessPointProvisioningQueries apProvisioningQueries, AccessPointSoftwareUpdateProcessing accessPointSoftwareUpdateProcessing) throws DatasetException {
        super(transactionSupplier);
        this.discoveryProcessing = new DiscoveryModuleProcessing(infoDataset);
        this.situationProcessing = new SituationsUpdateProcessing(this, apProvisioningQueries, infoDataset);
        this.softwareUpdateProcessing = accessPointSoftwareUpdateProcessing;
        this.configDataset = configDataset;
        this.infoDataset = infoDataset;
        try {
            this.addModules(new LancomModulesProvider(apProvisioningQueries, infoDataset));
        }
        catch (Exception exc) {
            logger.error("Could not initialize LancomModulesProvider: %s", new Object[]{exc.getMessage()});
            logger.logException((Throwable)exc);
        }
        this.addModules(new SimulatedModulesProvider());
        this.addModules(new SimulatedThinApModulesProvider());
    }

    public AccessPointTypeModules getAccessPointTypeModules(int accessPointId) {
        AccessPointType apType = AccessPointTypeMapping.getType((int)accessPointId);
        return this.apType2ModulesMapping.get(apType);
    }

    private void setupTypeModules(EnvironmentProperties env) {
        boolean sslEnabled = Config.isAccessPointSsl();
        for (AccessPointTypeModules modules : this.apType2ModulesMapping.values()) {
            ModuleSpecificSettings settings = modules.newSettings(env);
            modules.serviceModule.init(sslEnabled);
            modules.serviceModule.receive(settings);
            modules.discoveryModule.init(sslEnabled, settings.isDiscoveryEnabled());
            modules.discoveryModule.receive(settings);
            modules.configModule.init(sslEnabled);
            modules.configModule.receive(settings);
            modules.decisionLogicModule.receive(settings);
            modules.softwareUpdateModule.receive(settings);
        }
    }

    public void addModules(AccessPointModulesProvider provider) {
        AccessPointTypeModules apm = new AccessPointTypeModules(provider);
        this.apType2ModulesMapping.put(apm.apType, apm);
        this.infoDataset.addDiscoveryModule(apm.discoveryModule);
    }

    public void executeAccessPointRemoval(int accessPointId) {
        AccessPointConfigSituation situation = this.apConfigMapping.get(accessPointId);
        if (situation != null) {
            situation.clearTargetAndReset();
        }
        this.infoDataset.removeAccessPoint(accessPointId);
    }

    public void externalExecuteSituationsUpdate(Transaction<?> transaction) {
        EnvironmentProperties env = this.updateEnvironmentProperties();
        if (env != null) {
            this.setupTypeModules(env);
            this.situationProcessing.executeSituationsUpdate(this.apConfigMapping, this.configDataset, env, transaction);
        }
    }

    public void run() throws Exception {
        Transaction transaction = this.getTransactionSupplier().newTransaction();
        try {
            EnvironmentProperties environmentProperties = this.updateEnvironmentProperties();
            if (environmentProperties != null) {
                this.discoveryProcessing.startOrStopExecutionOfModules(this.apType2ModulesMapping);
                this.setupTypeModules(environmentProperties);
                this.discoveryProcessing.processDiscovery(this.apConfigMapping, this.apType2ModulesMapping);
                this.situationProcessing.executeSituationsUpdate(this.apConfigMapping, this.configDataset, environmentProperties, transaction);
                SituationOperationModeProcessing.executeOperationModeUpdate(this.apConfigMapping);
            }
            this.softwareUpdateProcessing.processUpdates(this.apConfigMapping, this, transaction);
            transaction.commit();
        }
        catch (Exception exc) {
            transaction.rollback();
            throw exc;
        }
    }

    private EnvironmentProperties updateEnvironmentProperties() {
        try {
            EnvironmentProperties environmentProperties = new EnvironmentProperties(false);
            EnvironmentPropertiesHelper.setProperties((EnvironmentProperties)environmentProperties);
            return environmentProperties;
        }
        catch (InitializationException exc) {
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            EnvironmentPropertiesHelper.setProperties(null);
            return null;
        }
    }

    public void shutdown() {
        for (AccessPointTypeModules apm : this.apType2ModulesMapping.values()) {
            if (apm.discoveryModule.getMode() != DiscoveryMode.WORK_IN_BACKGROUND) continue;
            apm.discoveryModule.shutdown();
        }
    }

    public void start() {
        for (AccessPointTypeModules apm : this.apType2ModulesMapping.values()) {
            if (apm.discoveryModule.getMode() != DiscoveryMode.WORK_IN_BACKGROUND) continue;
            apm.discoveryModule.start();
        }
    }
}

