/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.admin.platform.EnvironmentPropertiesHelper;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.server.provisioning.AccessPointModulesProvider;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.SettingsCreator;
import at.mrdevelopment.esl.server.provisioning.configuration.ConfigurationModule;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.DecisionLogicModule;
import at.mrdevelopment.esl.server.provisioning.discovery.DiscoveryModule;
import at.mrdevelopment.esl.server.provisioning.service.ServiceModule;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.SoftwareUpdateModule;

public class AccessPointTypeModules {
    final AccessPointType apType;
    final ConfigurationModule configModule;
    final DiscoveryModule discoveryModule;
    final DecisionLogicModule decisionLogicModule;
    final ServiceModule serviceModule;
    final SoftwareUpdateModule softwareUpdateModule;
    private final SettingsCreator settingsCreator;
    private ModuleSpecificSettings oldSettings;

    AccessPointTypeModules(AccessPointModulesProvider provider) {
        this.apType = provider.getAccessPointType();
        this.configModule = provider.getConfigurationModule();
        this.discoveryModule = provider.getDiscoveryModule();
        this.decisionLogicModule = provider.getDecisioLogicModule();
        this.serviceModule = provider.getServiceModule();
        this.settingsCreator = provider.getSettingsCreator();
        this.softwareUpdateModule = provider.getSoftwareUpdateModule();
        EnvironmentProperties env = EnvironmentPropertiesHelper.getProperties();
        if (env != null) {
            this.oldSettings = this.settingsCreator.create(env);
        }
    }

    public ConfigurationModule getConfig() {
        return this.configModule;
    }

    public DiscoveryModule getDiscovery() {
        return this.discoveryModule;
    }

    public DecisionLogicModule getDecisionLogic() {
        return this.decisionLogicModule;
    }

    public ServiceModule getService() {
        return this.serviceModule;
    }

    public ModuleSpecificSettings getLatestSettings() {
        return this.oldSettings;
    }

    public ModuleSpecificSettings newSettings(EnvironmentProperties env) {
        ModuleSpecificSettings newSettings = this.settingsCreator.create(env);
        newSettings.calculateDifferences(this.oldSettings);
        this.oldSettings = newSettings;
        return newSettings;
    }

    public SoftwareUpdateModule getSoftwareUpdateModule() {
        return this.softwareUpdateModule;
    }
}

