/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.server.http.widget.BarWidget;
import at.mrdevelopment.toolkit.log.ESLLogger;

public class UpdateStatusBarWidget
extends BarWidget {
    static ESLLogger logger = ESLLogger.getLogger(UpdateStatusBarWidget.class);
    private static final String WIDGET_ID = "update-status";
    private final Level1Implementation level1;

    public UpdateStatusBarWidget(Level1Implementation level1) {
        super(WIDGET_ID);
        this.level1 = level1;
    }

    @Override
    public void reload() {
        this.clearValues();
        DatasetQuery labelsQuery = this.level1.getQuery("labelinfo/index");
        try {
            QueryResult allLabels = this.level1.executeQuery(labelsQuery, QueryRestriction.newUnpagedQuery());
            this.setMaxValue(allLabels.getTotalRecords());
            int unsuccessful = 0;
            int waiting = 0;
            int aborted = 0;
            int successful = 0;
            int pending = 0;
            for (LabelInfo labelInfo : allLabels.getRecords()) {
                if (labelInfo.getStatus() == null) continue;
                if (labelInfo.getStatus().isUnsuccessful()) {
                    ++unsuccessful;
                    continue;
                }
                if (labelInfo.getStatus().isWaiting()) {
                    ++waiting;
                    continue;
                }
                if (labelInfo.getStatus().isSuccessful()) {
                    ++successful;
                    continue;
                }
                if (labelInfo.getStatus().isAborted()) {
                    ++aborted;
                    continue;
                }
                if (!labelInfo.getStatus().isDelayed()) continue;
                ++pending;
            }
            this.addValue("SUCCESSFUL", successful, BarWidget.BarColor.GREEN, "/service/labelinfo/successful.xml?page=0");
            this.addValue("WAITING", waiting, BarWidget.BarColor.BLUE, "/service/labelinfo/waiting.xml?page=0");
            this.addValue("UNSUCCESSFUL", unsuccessful, BarWidget.BarColor.RED, "/service/labelinfo/unsuccessful.xml?page=0");
            this.addValue("ABORTED", aborted, BarWidget.BarColor.GRAY, "/service/labelinfo/aborted.xml?page=0");
            this.addValue("PENDING", pending, BarWidget.BarColor.ORANGE, "/service/labelinfo/pending.xml?page=0");
        }
        catch (DatasetException exc) {
            logger.warn("Could not query label information: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }

    @Override
    protected String getTitle() {
        return "Updates";
    }
}

