/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.core.LinkQuality;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.server.http.widget.BarWidget;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;

public class SignalStrengthBarWidget
extends BarWidget {
    static ESLLogger logger = ESLLogger.getLogger(SignalStrengthBarWidget.class);
    private final Level1Implementation level1;
    private int labelCount;

    public SignalStrengthBarWidget(Level1Implementation level1) {
        super("sync-quality");
        this.level1 = level1;
    }

    @Override
    public void reload() {
        this.clearValues();
        ServiceStatus serviceStatus = this.level1.getServiceStatus(UserId.SYSTEM);
        this.labelCount = Integer.valueOf(serviceStatus.getPropertyValue("labels"));
        this.setMaxValue(this.labelCount);
        DatasetQuery syncQualityQuery = this.level1.getQuery("labelinfo/syncquality");
        DatasetQuery notSeenQuery = this.level1.getQuery("labelinfo/notseenforminutes");
        try {
            DatasetQuery lowerRssiQuery = this.level1.getQuery("labelinfo/rssi/lower");
            QueryResult lowerRssiLabels = this.level1.executeQuery(lowerRssiQuery, QueryRestriction.newSearchQuery(Integer.class, (Object)-80, (Integer)0, (Integer)1, (int)1));
            int badRssiCount = lowerRssiLabels.getTotalRecords();
            DatasetQuery higherRssiQuery = this.level1.getQuery("labelinfo/rssi/higher");
            QueryResult higherRssiLabels = this.level1.executeQuery(higherRssiQuery, QueryRestriction.newSearchQuery(Integer.class, (Object)-80, (Integer)0, (Integer)1, (int)1));
            int goodRssiCount = higherRssiLabels.getTotalRecords();
            QueryResult badLabels = this.level1.executeQuery(syncQualityQuery, QueryRestriction.newSearchQuery(LinkQuality.class, (Object)LinkQuality.BAD, (Integer)0, (Integer)1, (int)1));
            this.addValue("Bad Sync Quality", badLabels.getTotalRecords(), BarWidget.BarColor.RED, "/service/labelinfo/syncquality/bad.xml?page=0");
            QueryResult averageLabels = this.level1.executeQuery(syncQualityQuery, QueryRestriction.newSearchQuery(LinkQuality.class, (Object)LinkQuality.AVERAGE, (Integer)0, (Integer)1, (int)1));
            this.addValue("AVG Sync Quality", averageLabels.getTotalRecords(), BarWidget.BarColor.ORANGE, "/service/labelinfo/syncquality/average.xml?page=0");
            this.addValue("RSSI > -80", goodRssiCount, BarWidget.BarColor.GREEN, "/service/labelinfo/rssi/higher/-80.xml?page=0");
            this.addValue("RSSI <= -80", badRssiCount, BarWidget.BarColor.RED, "/service/labelinfo/rssi/lower/-80.xml?page=0");
            QueryResult notSeenResult = this.level1.executeQuery(notSeenQuery, QueryRestriction.newSearchQuery(Integer.class, (Object)60, (Integer)0, (Integer)1, (int)1));
            this.addValue("Not Seen Last Hour", notSeenResult.getTotalRecords(), BarWidget.BarColor.ORANGE, "/service/labelinfo/notseenforminutes/60.xml?page=0");
        }
        catch (DatasetException exc) {
            logger.warn("Could not query label information: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }

    @Override
    protected String getTitle() {
        return "Label Signal Quality";
    }
}

