/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.maintenance.job.JobStatistic;
import at.mrdevelopment.esl.persistence.maintenance.job.JobStatistics;
import at.mrdevelopment.esl.server.http.widget.TextBasedWidget;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ServiceSchedulingWidget
extends TextBasedWidget {
    static ESLLogger logger = ESLLogger.getLogger(ServiceSchedulingWidget.class);
    private static final String WIDGET_ID = "service-scheduling";
    private static final String WIDGET_TITLE = "Service Scheduling";
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.mediumDateTime();
    private final Level1Implementation level1;

    public ServiceSchedulingWidget(Level1Implementation level1) {
        super(WIDGET_ID);
        this.level1 = level1;
    }

    @Override
    public void reload() {
        this.clearFields();
        try {
            JobStatistics jobStatistics = this.level1.getJobStatistics();
            JobStatistic currentStatistic = null;
            JobStatistic nextStatistic = null;
            DateTime next = null;
            for (JobStatistic jobStatistic : jobStatistics.getStatistics()) {
                if (jobStatistic.isRunning()) {
                    currentStatistic = jobStatistic;
                }
                if (next != null && !jobStatistic.getNextFireTime().isBefore((ReadableInstant)next)) continue;
                next = jobStatistic.getNextFireTime();
                nextStatistic = jobStatistic;
            }
            this.addField("Next job", nextStatistic.getName());
            this.addField("Starting at", FORMATTER.print((ReadableInstant)nextStatistic.getNextFireTime()));
            this.addField("Execution count", String.format("%d", nextStatistic.getExecutionCount()));
            if (nextStatistic.getExecutionMillis() > 0L) {
                this.addField("Last duration", String.format("%d ms", nextStatistic.getExecutionMillis()));
            }
            if (currentStatistic != null) {
                this.addField("Current job", currentStatistic.getName());
                this.addField("Started at", FORMATTER.print((ReadableInstant)currentStatistic.getPreviousFireTime()));
                this.addField("Duration", String.format("%d ms (last: %d ms)", currentStatistic.getCurrentExecutionMillis(), currentStatistic.getExecutionMillis()));
            }
        }
        catch (DatasetException exc) {
            logger.warn("Could not load scheduling information: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }

    @Override
    public String getWidgetTitle() {
        return WIDGET_TITLE;
    }
}

