/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.custom.level1.Level1Connector;
import at.mrdevelopment.esl.custom.level2.Level2Connector;
import at.mrdevelopment.esl.custom.level3.Level3Connector;
import at.mrdevelopment.esl.server.Level1Server;
import at.mrdevelopment.esl.server.http.widget.TextBasedWidget;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Collection;

public class PluginsWidget
extends TextBasedWidget {
    static ESLLogger logger = ESLLogger.getLogger(PluginsWidget.class);
    private static final String WIDGET_ID = "plugins";
    private final Level1Server level1;
    private int pluginCount;

    public PluginsWidget(Level1Server level1) {
        super(WIDGET_ID);
        this.level1 = level1;
    }

    @Override
    public void reload() {
        this.clearFields();
        Collection<Class<? extends Level1Connector>> connectors = this.level1.getActivatedConnectors();
        this.pluginCount = 0;
        for (Class<? extends Level1Connector> connector : connectors) {
            if (connector.getSimpleName().equals("Level1Implementation") || connector.getSimpleName().equals("Level2Implementation") || connector.getSimpleName().equals("Level3Implementation") || connector.getSimpleName().contains("WebserviceLevel") || connector.getSimpleName().contains("ServiceDebugWindow")) continue;
            String level = Level3Connector.class.isAssignableFrom(connector) ? "Level 3" : (Level2Connector.class.isAssignableFrom(connector) ? "Level 2" : "Level 1");
            this.addField(connector.getSimpleName(), level);
        }
        this.pluginCount = this.getFieldCount();
    }

    @Override
    public String getWidgetTitle() {
        return String.format("%d Plugin(s) Active", this.pluginCount);
    }
}

