/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.Pair;
import at.mrdevelopment.esl.server.http.widget.WidgetInterface;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.text.PercentageFormatter;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PieWidget
implements WidgetInterface {
    private static final int PIE_CHART_HEIGHT = 512;
    private static final int PIE_CHART_WIDTH = 512;
    private int maxValue;
    private final Map<String, Integer> values;
    private final Map<String, PieColor> colors;
    private final Map<String, String> descriptions;
    private final String id;
    private String base64String;

    public PieWidget(String id) {
        this.id = id;
        this.values = new LinkedHashMap<String, Integer>();
        this.colors = new LinkedHashMap<String, PieColor>();
        this.descriptions = new LinkedHashMap<String, String>();
    }

    protected void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    protected void addValue(String name, int value, PieColor color, String description) {
        this.values.put(name, value);
        this.colors.put(name, color);
        this.descriptions.put(name, description);
    }

    protected void clearValues() {
        this.values.clear();
        this.colors.clear();
        this.descriptions.clear();
    }

    @Override
    public void toXML(Document document, Element root) throws SerializeException {
        if (this.base64String != null && !this.base64String.isEmpty()) {
            Element widgetElement = document.createElement("pie-widget");
            widgetElement.setAttribute("title", this.getTitle());
            widgetElement.setAttribute("id", this.id);
            widgetElement.setAttribute("image", this.base64String);
            widgetElement.setAttribute("total", Integer.toString(this.maxValue));
            for (Map.Entry<String, Integer> entry : this.values.entrySet()) {
                Element fieldElement = document.createElement("field");
                fieldElement.setAttribute("name", entry.getKey());
                fieldElement.setAttribute("description", this.descriptions.get(entry.getKey()));
                fieldElement.setAttribute("value", String.valueOf(entry.getValue()));
                fieldElement.setAttribute("color", this.colors.get(entry.getKey()).toString());
                fieldElement.setAttribute("percentage", PercentageFormatter.format((int)entry.getValue(), (int)this.maxValue));
                widgetElement.appendChild(fieldElement);
            }
            root.appendChild(widgetElement);
        }
    }

    protected void reloadBase64String() throws SerializeException {
        ArrayList<Pair> slices = new ArrayList<Pair>(this.values.size());
        for (Map.Entry<String, Integer> entry : this.values.entrySet()) {
            slices.add(new Pair((Object)entry.getValue(), (Object)this.colors.get(entry.getKey()).getColor()));
        }
        BufferedImage bufferedImage = new BufferedImage(512, 512, 2);
        Graphics2D graphics = bufferedImage.createGraphics();
        Rectangle rectangle = new Rectangle(512, 512);
        ImageUtils.drawPie((Graphics2D)graphics, (Rectangle)rectangle, slices);
        this.base64String = ImageSerializer.toBase64String((BufferedImage)bufferedImage);
    }

    protected abstract String getTitle();

    public static enum PieColor {
        GREEN1(new Color(0, 187, 49)),
        GREEN2(new Color(50, 200, 90)),
        GREEN3(new Color(102, 214, 131)),
        GREEN4(new Color(153, 227, 172)),
        GREEN5(new Color(204, 241, 213)),
        RED(new Color(255, 85, 85)),
        BLUE(new Color(0, 187, 255)),
        ORANGE(new Color(255, 187, 0)),
        GRAY(new Color(170, 170, 170));

        private final Color color;

        private PieColor(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        public String toString() {
            return String.format("#%s", Integer.toHexString(this.getColor().getRGB()).substring(2));
        }
    }
}

