/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.server.http.widget.TextBasedWidget;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;

public class LicenseStatusWidget
extends TextBasedWidget {
    static ESLLogger logger = ESLLogger.getLogger(LicenseStatusWidget.class);
    private static final String WIDGET_ID = "license-status";
    private final Level1Implementation level1;
    private String mode;

    public LicenseStatusWidget(Level1Implementation level1) {
        super(WIDGET_ID);
        this.level1 = level1;
    }

    @Override
    public void reload() {
        this.clearFields();
        ServiceStatus serviceStatus = this.level1.getServiceStatus(UserId.SYSTEM);
        this.mode = serviceStatus.getPropertyValue("licensed-mode");
        String customer = serviceStatus.getPropertyValue("licensed-customer");
        this.addField("Customer", customer);
        String labelCount = serviceStatus.getPropertyValue("labels");
        String licensedLabels = serviceStatus.getPropertyValue("licensed-labels");
        this.addField("Labels", String.format("Licensed: %s / Registered: %s", licensedLabels, labelCount));
        String licensedAccessPoints = serviceStatus.getPropertyValue("licensed-access-points");
        String accessPointCount = serviceStatus.getPropertyValue("access-points");
        this.addField("AccessPoints", String.format("Licensed: %s / Registered: %s", licensedAccessPoints, accessPointCount));
        boolean productive = serviceStatus.getBooleanValue("licensed-productive");
        if (!productive) {
            this.addField("Warning", "License not valid for productive environments");
        }
    }

    @Override
    public String getWidgetTitle() {
        return String.format("License: %s", this.mode);
    }
}

