/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.server.http.widget.BarWidget;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.HashMap;
import java.util.List;

public class LabelsOnAccessPointBarWidget
extends BarWidget {
    static ESLLogger logger = ESLLogger.getLogger(LabelsOnAccessPointBarWidget.class);
    private final Level1Implementation level1;

    public LabelsOnAccessPointBarWidget(Level1Implementation level1) {
        super("labels-on-accespoints");
        this.level1 = level1;
    }

    @Override
    public void reload() {
        this.clearValues();
        try {
            DatasetQuery labelInfoQuery = this.level1.getQuery("labelinfo/index");
            QueryResult allLabels = this.level1.executeQuery(labelInfoQuery, QueryRestriction.newUnpagedQuery());
            DatasetQuery accessPointInfoQuery = this.level1.getQuery("accesspointinfo/index");
            QueryResult allAccesspoints = this.level1.executeQuery(accessPointInfoQuery, QueryRestriction.newUnpagedQuery());
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            List records = allLabels.getRecords();
            this.setMaxValue(allLabels.getTotalRecords());
            for (LabelInfo labelInfo : records) {
                Integer count;
                Integer accessPointId = labelInfo.getAccessPointId();
                if (accessPointId == null || accessPointId <= 0) continue;
                if (!map.containsKey(accessPointId)) {
                    map.put(accessPointId, 0);
                }
                Integer n = count = (Integer)map.get(accessPointId);
                Integer n2 = count = Integer.valueOf(count + 1);
                map.put(accessPointId, count);
            }
            for (AccessPointInfo info : allAccesspoints.getRecords()) {
                if (info.isDiscovered()) continue;
                if (map.containsKey(info.getAccessPointId())) {
                    int count = (Integer)map.get(info.getAccessPointId());
                    this.addValue(this.createName(info.getAccessPointId(), info), count, BarWidget.BarColor.BLUE, info != null ? info.getAddress() + "service/status.xml" : "");
                    continue;
                }
                this.addValue(this.createName(info.getAccessPointId(), info), 0, BarWidget.BarColor.BLUE, info != null ? info.getAddress() + "service/status.xml" : "");
            }
        }
        catch (DatasetException exc) {
            logger.error("Failed query label info: %s", new Object[]{exc.getMessage()});
            logger.logException((Throwable)exc);
        }
    }

    private String createName(Integer accessPointId, AccessPointInfo accessPointInfo) {
        String channelString;
        String statusString = accessPointInfo.isOffline() ? "OFFLINE" : "";
        String string = channelString = accessPointInfo != null && accessPointInfo.getChannel() != null ? String.format("Ch #%d", accessPointInfo.getChannel().getChannelId()) : "";
        if (statusString.length() == 0 && channelString.length() == 0) {
            return String.format("%d", accessPointId);
        }
        if (statusString.length() != 0 && channelString.length() == 0) {
            return String.format("%d [%s]", accessPointId, statusString);
        }
        if (statusString.length() == 0 && channelString.length() != 0) {
            return String.format("%d [%s]", accessPointId, channelString.trim());
        }
        return String.format("%d [%s|%s]", accessPointId, statusString, channelString);
    }

    @Override
    protected String getTitle() {
        return "Label Distribution";
    }
}

