/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.server.http.widget.TextBasedWidget;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;

public class LabelStatusWidget
extends TextBasedWidget {
    static ESLLogger logger = ESLLogger.getLogger(LabelStatusWidget.class);
    private static final String WIDGET_ID = "label-status";
    private final Level1Implementation level1;
    private int labelCount;

    public LabelStatusWidget(Level1Implementation level1) {
        super(WIDGET_ID);
        this.level1 = level1;
    }

    @Override
    public void reload() {
        this.clearFields();
        ServiceStatus serviceStatus = this.level1.getServiceStatus(UserId.SYSTEM);
        this.labelCount = Integer.valueOf(serviceStatus.getPropertyValue("labels"));
        DatasetQuery powerBadQuery = this.level1.getQuery("labelinfo/powerstatus");
        DatasetQuery errorQuery = this.level1.getQuery("labelinfo/error");
        DatasetQuery encryptionQuery = this.level1.getQuery("labelinfo/noencryption");
        DatasetQuery offlineQuery = this.level1.getQuery("labelinfo/status");
        try {
            QueryResult labelsWithPowerBad = this.level1.executeQuery(powerBadQuery, QueryRestriction.newSearchQuery(PowerStatus.class, (Object)PowerStatus.BAD, (Integer)0, (Integer)1, (int)1));
            this.addField("Labels with Power Status Bad", String.valueOf(labelsWithPowerBad.getTotalRecords()));
            QueryResult labelsWithErrors = this.level1.executeQuery(errorQuery, QueryRestriction.newQuery((Integer)0, (Integer)1, (int)1));
            this.addField("Labels with Errors", String.valueOf(labelsWithErrors.getTotalRecords()));
            QueryResult labelsWithoutEncryption = this.level1.executeQuery(encryptionQuery, QueryRestriction.newQuery((Integer)0, (Integer)1, (int)1));
            this.addField("Unencrypted Labels", String.valueOf(labelsWithoutEncryption.getTotalRecords()));
            QueryResult offlineLabels = this.level1.executeQuery(offlineQuery, QueryRestriction.newSearchQuery(ConnectionStatus.class, (Object)ConnectionStatus.OFFLINE, (Integer)0, (Integer)1, (int)1));
            this.addField("Offline Labels", String.valueOf(offlineLabels.getTotalRecords()));
        }
        catch (DatasetException exc) {
            logger.warn("Could not query label information: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }

    @Override
    public String getWidgetTitle() {
        return String.format("%d Label(s)", this.labelCount);
    }
}

