/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.server.http.widget.TextBasedWidget;
import at.mrdevelopment.toolkit.authentication.UserId;

public class DeviceInfoWidget
extends TextBasedWidget {
    private static final String WIDGET_ID = "device-info";
    private static final String WIDGET_TITLE = "Device Info";
    private final Level1Implementation level1;

    public DeviceInfoWidget(Level1Implementation level1) {
        super(WIDGET_ID);
        this.level1 = level1;
    }

    @Override
    public void reload() {
        this.clearFields();
        ServiceStatus serviceStatus = this.level1.getServiceStatus(UserId.SYSTEM);
        if (serviceStatus.hasProperty("id")) {
            this.addField("ID", serviceStatus.getPropertyValue("id"));
        }
        this.addField("Version", String.format("%s (%s)", serviceStatus.getPropertyValue("version"), serviceStatus.getPropertyValue("build")));
        this.addField("Uptime", serviceStatus.getPropertyValue("service-uptime"));
        this.addField("Server Time", serviceStatus.getPropertyValue("server-time"));
    }

    @Override
    public String getWidgetTitle() {
        return WIDGET_TITLE;
    }
}

