/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.server.http.widget.TextBasedWidget;
import at.mrdevelopment.toolkit.authentication.UserId;

public class DatabaseInfoWidget
extends TextBasedWidget {
    private static final String WIDGET_ID = "database-info";
    private static final String WIDGET_TITLE = "Database Info";
    private static final String NOT_AVAILABLE = "N/A";
    private final Level1Implementation level1;

    public DatabaseInfoWidget(Level1Implementation level1) {
        super(WIDGET_ID);
        this.level1 = level1;
    }

    @Override
    public void reload() {
        this.clearFields();
        ServiceStatus serviceStatus = this.level1.getServiceStatus(UserId.SYSTEM);
        this.addField("Total size", serviceStatus.hasProperty("db-size-total") ? serviceStatus.getPropertyValue("db-size-total") : NOT_AVAILABLE);
        this.addField("Size used", serviceStatus.hasProperty("db-size-used") ? serviceStatus.getPropertyValue("db-size-used") : NOT_AVAILABLE);
        this.addField("Size freeable", serviceStatus.hasProperty("db-size-freeable") ? serviceStatus.getPropertyValue("db-size-freeable") : NOT_AVAILABLE);
        this.addField("Product name", serviceStatus.hasProperty("db-product-name") ? serviceStatus.getPropertyValue("db-product-name") : NOT_AVAILABLE);
        this.addField("Product version", serviceStatus.hasProperty("db-product-version") ? serviceStatus.getPropertyValue("db-product-version") : NOT_AVAILABLE);
        this.addField("Driver name", serviceStatus.hasProperty("db-driver-name") ? serviceStatus.getPropertyValue("db-driver-name") : NOT_AVAILABLE);
        this.addField("Driver version", serviceStatus.hasProperty("db-driver-version") ? serviceStatus.getPropertyValue("db-driver-version") : NOT_AVAILABLE);
        this.addField("URL", serviceStatus.hasProperty("db-url") ? serviceStatus.getPropertyValue("db-url") : NOT_AVAILABLE);
    }

    @Override
    public String getWidgetTitle() {
        return WIDGET_TITLE;
    }
}

