/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.server.http.widget.WidgetInterface;
import at.mrdevelopment.toolkit.text.PercentageFormatter;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BarWidget
implements WidgetInterface {
    private int maxValue;
    private final Map<String, Integer> values;
    private final Map<String, BarColor> colors;
    private final Map<String, String> urls;
    private final String id;

    public BarWidget(String id) {
        this.id = id;
        this.values = new LinkedHashMap<String, Integer>();
        this.colors = new HashMap<String, BarColor>();
        this.urls = new HashMap<String, String>();
    }

    protected void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    protected void addValue(String name, int value, BarColor color, String url) {
        this.values.put(name, value);
        this.colors.put(name, color);
        this.urls.put(name, url);
    }

    protected void clearValues() {
        this.values.clear();
        this.colors.clear();
        this.urls.clear();
    }

    @Override
    public void toXML(Document document, Element root) throws SerializeException {
        Element widgetElement = document.createElement("bar-widget");
        widgetElement.setAttribute("title", this.getTitle());
        widgetElement.setAttribute("id", this.id);
        widgetElement.setAttribute("total", Integer.toString(this.values.size()));
        int id = 1;
        for (Map.Entry<String, Integer> entry : this.values.entrySet()) {
            Element fieldElement = document.createElement("field");
            fieldElement.setAttribute("name", entry.getKey());
            fieldElement.setAttribute("value", String.valueOf(entry.getValue()));
            fieldElement.setAttribute("id", String.valueOf(id));
            fieldElement.setAttribute("color", this.colors.get(entry.getKey()).getColor());
            fieldElement.setAttribute("url", this.urls.get(entry.getKey()));
            String percentage = PercentageFormatter.format((int)entry.getValue(), (int)this.maxValue);
            fieldElement.setAttribute("percentage", percentage);
            widgetElement.appendChild(fieldElement);
            ++id;
        }
        root.appendChild(widgetElement);
    }

    protected abstract String getTitle();

    public static enum BarColor {
        GREEN("#5f5"),
        RED("#f55"),
        BLUE("#0bf"),
        ORANGE("#fb0"),
        GRAY("#aaa");

        private final String color;

        private BarColor(String color) {
            this.color = color;
        }

        public String getColor() {
            return this.color;
        }
    }
}

