/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http;

import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.maintenance.job.CronBasedJobConfiguration;
import at.mrdevelopment.esl.persistence.maintenance.job.CronJobConfiguration;
import at.mrdevelopment.esl.persistence.maintenance.job.JobConfiguration;
import at.mrdevelopment.esl.persistence.maintenance.job.JobStatistic;
import at.mrdevelopment.esl.persistence.maintenance.job.JobStatistics;
import at.mrdevelopment.esl.persistence.maintenance.job.TimeBasedJobConfiguration;
import at.mrdevelopment.esl.server.ServiceScheduler;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Restrict;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.spi.LoggingEvent;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.quartz.JobDataMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Route(route="/service/scheduler")
public class ServiceSchedulingWebserviceRequestHandler
implements WebserviceRequestHandler {
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"dd.MM.yyyy HH:mm:ss");
    private static final DateTimeFormatter DETAILED_FORMATTER = DateTimeFormat.forPattern((String)"dd.MM.yyyy HH:mm:ss.SSS");
    private final XMLToolkit xmlToolkit;
    private final ServiceScheduler serviceScheduler;

    public ServiceSchedulingWebserviceRequestHandler(Level1Implementation level1, ServiceScheduler serviceScheduler) throws InitializationException {
        this.serviceScheduler = serviceScheduler;
        this.xmlToolkit = new XMLToolkit();
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="scheduling.xml")
    public void getScheduling(WebserviceRequest request, WebserviceResponse response) throws Exception {
        JobStatistics jobStatistics = this.serviceScheduler.getJobStatistics();
        Document document = this.createDocument(jobStatistics);
        List<LoggingEvent> loggingEvents = this.serviceScheduler.getLoggingEvents();
        this.appendLoggingEvents(document, loggingEvents);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="trigger/:key.xml", pattern=".+")
    public void triggerJob(WebserviceRequest request, WebserviceResponse response) throws Exception {
        String jobName = request.getUrlBaseName();
        this.serviceScheduler.triggerJob(jobName);
        response.respondMessage(String.format("Job %s triggered for execution", jobName));
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="cancel/:key.xml", pattern=".+")
    public void cancelJob(WebserviceRequest request, WebserviceResponse response) throws Exception {
        String jobName = request.getUrlBaseName();
        boolean success = this.serviceScheduler.cancelJobExecution(jobName);
        if (success) {
            response.respondMessage(String.format("Job %s scheduled for cancellation", jobName));
        } else {
            response.respondMessage(String.format("Could not cancel job %s", jobName));
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="details/:key.xml", pattern=".+")
    public void getJobRuntimeConfiguration(WebserviceRequest request, WebserviceResponse response) throws Exception {
        String jobName = request.getUrlBaseName();
        JobConfiguration jobConfiguration = this.serviceScheduler.getJobConfiguration(jobName);
        Document document = this.createDocument(jobConfiguration);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    private void appendLoggingEvents(Document document, List<LoggingEvent> loggingEvents) {
        Element root = document.getDocumentElement();
        Element loggingEventsElement = document.createElement("LoggingEvents");
        for (LoggingEvent event : loggingEvents) {
            Element loggingEventElement = document.createElement("LoggingEvent");
            loggingEventElement.setAttribute("level", event.getLevel().toString());
            loggingEventElement.setAttribute("timestamp", DETAILED_FORMATTER.print(event.timeStamp));
            loggingEventElement.setTextContent(event.getRenderedMessage());
            loggingEventsElement.appendChild(loggingEventElement);
        }
        root.appendChild(loggingEventsElement);
    }

    private Document createDocument(JobConfiguration jobConfiguration) throws DOMException, DatasetException {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("JobRuntimeConfiguration");
        root.setAttribute("name", jobConfiguration.getJobIdentifier());
        root.setAttribute("enabled", String.valueOf(jobConfiguration.isEnabled()));
        if (jobConfiguration instanceof CronBasedJobConfiguration) {
            CronBasedJobConfiguration cronBasedJobConfiguration = (CronBasedJobConfiguration)jobConfiguration;
            root.setAttribute("enabledKey", cronBasedJobConfiguration.getConfigKeyEnabled());
            root.setAttribute("scheduleKey", cronBasedJobConfiguration.getConfigKeySchedule());
            root.setAttribute("enabledDefault", cronBasedJobConfiguration.getEnabledConfiguration().getDefaultValue());
            root.setAttribute("scheduleDefault", cronBasedJobConfiguration.getScheduleConfiguration().getDefaultValue());
        }
        if (jobConfiguration instanceof TimeBasedJobConfiguration) {
            TimeBasedJobConfiguration timeBasedJobConfiguration = (TimeBasedJobConfiguration)jobConfiguration;
            root.setAttribute("configKey", timeBasedJobConfiguration.getTimeBasedConfigurationProfile().getKey());
            root.setAttribute("configValue", timeBasedJobConfiguration.getTimeBasedConfigurationProfile().getValue());
        }
        if (jobConfiguration instanceof CronJobConfiguration) {
            CronJobConfiguration cronJobConfiguration = (CronJobConfiguration)jobConfiguration;
            root.setAttribute("schedule", cronJobConfiguration.getSchedule());
            Element cronExpressionsElement = document.createElement("CronExpressions");
            Collection<String> cronExpression = cronJobConfiguration.getCronExpressionSummary();
            if (cronExpression != null) {
                for (String cron : cronExpression) {
                    Element cronExpressionElement = document.createElement("CronExpression");
                    cronExpressionElement.setTextContent(cron);
                    cronExpressionsElement.appendChild(cronExpressionElement);
                }
            }
            root.appendChild(cronExpressionsElement);
        }
        document.appendChild(root);
        return document;
    }

    private Document createDocument(JobStatistics jobStatistics) {
        Document document = this.xmlToolkit.newDocument();
        Element root = document.createElement("JobStatistics");
        root.setAttribute("currentDateTime", FORMATTER.print((ReadableInstant)DateTime.now()));
        List<JobStatistic> statistics = jobStatistics.getStatistics();
        for (JobStatistic jobStatistic : statistics) {
            Element jobStatisticElement = document.createElement("JobStatistic");
            jobStatisticElement.setAttribute("running", String.valueOf(jobStatistic.isRunning()));
            jobStatisticElement.setAttribute("enabled", String.valueOf(jobStatistic.isEnabled()));
            jobStatisticElement.setAttribute("manuallyTriggered", String.valueOf(jobStatistic.isManuallyTriggered()));
            jobStatisticElement.setAttribute("name", jobStatistic.getName());
            jobStatisticElement.setAttribute("previous", jobStatistic.getPreviousFireTime() != null ? FORMATTER.print((ReadableInstant)jobStatistic.getPreviousFireTime()) : "-");
            jobStatisticElement.setAttribute("next", FORMATTER.print((ReadableInstant)jobStatistic.getNextFireTime()));
            jobStatisticElement.setAttribute("executionCount", String.valueOf(jobStatistic.getExecutionCount()));
            jobStatisticElement.setAttribute("executionMillis", String.valueOf(jobStatistic.getExecutionMillis()));
            jobStatisticElement.setAttribute("currentExecutionMillis", String.valueOf(jobStatistic.getCurrentExecutionMillis()));
            this.appendKeyValue(jobStatisticElement, jobStatistic);
            root.appendChild(jobStatisticElement);
        }
        document.appendChild(root);
        return document;
    }

    private void appendKeyValue(Element jobStatisticElement, JobStatistic jobStatistic) {
        JobDataMap jobDataMap = jobStatistic.getJobDataMap();
        String configKey = (String)jobDataMap.get((Object)"configurationKey");
        String configValue = (String)jobDataMap.get((Object)"configurationValue");
        if (configKey != null && configValue != null) {
            jobStatisticElement.setAttribute("configKey", configKey);
            jobStatisticElement.setAttribute("configValue", configValue);
        }
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

