/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.data;

import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.server.data.ESLDatabaseIdList;
import at.mrdevelopment.esl.server.data.GenericZipEntry;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.archive.ZipStreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class ZipPackage {
    static ESLLogger logger = ESLLogger.getLogger(ZipPackage.class);

    public static void writeArchive(Collection<GenericZipEntry<?>> zipEntries, OutputStream outputStream, PlatformStorage platformStorage) throws IOException {
        HashMap<String, ByteArrayInputStream> entries = new HashMap<String, ByteArrayInputStream>();
        try {
            for (GenericZipEntry<?> entry : zipEntries) {
                entries.put(entry.getEntryName(), ZipPackage.createStream(entry.getRecordClass(), entry.getRecord()));
            }
            ZipPackage.addConfigurationFileStream(entries, platformStorage);
            ZipStreamUtils.createZipStream((OutputStream)outputStream, entries);
        }
        catch (JAXBException exc) {
            throw new IOException(exc);
        }
        catch (SerializeException exc) {
            throw new IOException(exc);
        }
        finally {
            for (ByteArrayInputStream stream : entries.values()) {
                StreamUtils.close((InputStream)stream);
            }
        }
    }

    private static ByteArrayInputStream createStream(Class<?> jaxbClass, Object object) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{jaxbClass});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshaller.marshal(object, (OutputStream)outputStream);
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    public static Collection<GenericZipEntry<?>> readArchive(InputStream inputStream, PlatformStorage platformStorage, ClassLoader classLoader) throws IOException, SerializeException {
        Map entries = ZipStreamUtils.unzipStream((InputStream)inputStream);
        ByteArrayInputStream configurationEntry = (ByteArrayInputStream)entries.remove("configuration.backup");
        if (platformStorage != null && configurationEntry != null) {
            ZipPackage.loadConfigurationsFromFile(configurationEntry, platformStorage);
        }
        StreamUtils.close((InputStream)configurationEntry);
        return ZipPackage.readFromArchiveEntries(entries, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<GenericZipEntry<?>> readFromArchiveEntries(Map<String, ByteArrayInputStream> entries, ClassLoader classLoader) throws IOException {
        ArrayList zipEntries = new ArrayList();
        for (Map.Entry<String, ByteArrayInputStream> entry : entries.entrySet()) {
            try {
                Class<?> recordClass = ZipPackage.loadRecordClass(entry.getKey(), classLoader);
                zipEntries.add(new GenericZipEntry<Object>(recordClass, ZipPackage.unmarshall(recordClass, entry.getValue())));
            }
            catch (JAXBException exc) {
                logger.warn("Could not create wrapper instance: %s", new Object[]{exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
            catch (ClassNotFoundException exc) {
                logger.warn("Could not create wrapper instance: %s", new Object[]{exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
            catch (SerializeException exc) {
                logger.warn("Could not create wrapper instance: %s", new Object[]{exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
            finally {
                StreamUtils.close((InputStream)entry.getValue());
            }
        }
        return zipEntries;
    }

    private static Class<?> loadRecordClass(String name, ClassLoader classLoader) throws ClassNotFoundException {
        if (name.startsWith("ESLDatabaseIdList")) {
            return ESLDatabaseIdList.class;
        }
        return Class.forName(String.format("at.mrdevelopment.esl.type.wrapper.list.%s", name.replace(".xml", "")), true, classLoader);
    }

    private static Object unmarshall(Class<?> jaxbClass, InputStream inputStream) throws SerializeException, JAXBException {
        return ZipPackage.unwrapList(jaxbClass, inputStream);
    }

    private static <L> L unwrapList(Class<? extends L> wrapperListClass, InputStream inputStream) throws JAXBException, SerializeException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{wrapperListClass});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Object list = unmarshaller.unmarshal(inputStream);
            Field wrapperListField = wrapperListClass.getField("List");
            if (wrapperListField.get(list) == null) {
                ArrayList wrapperListInstance = new ArrayList();
                wrapperListField.set(list, wrapperListInstance);
            }
            return (L)list;
        }
        catch (IllegalArgumentException exc) {
            throw new SerializeException((Throwable)exc);
        }
        catch (IllegalAccessException exc) {
            throw new SerializeException((Throwable)exc);
        }
        catch (SecurityException exc) {
            throw new SerializeException((Throwable)exc);
        }
        catch (NoSuchFieldException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private static void addConfigurationFileStream(Map<String, ByteArrayInputStream> entries, PlatformStorage platformStorage) throws SerializeException, IOException {
        if (platformStorage != null) {
            entries.put("configuration.backup", ZipPackage.getConfigurationDataStream(platformStorage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteArrayInputStream getConfigurationDataStream(PlatformStorage platformStorage) throws SerializeException, IOException {
        Map configuration = platformStorage.queryConfiguration();
        Properties properties = new Properties();
        for (Map.Entry entry : configuration.entrySet()) {
            if (((String)entry.getKey()).startsWith("system") || entry.getValue() == null) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            properties.store((OutputStream)outputStream, "");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            StreamUtils.close((OutputStream)outputStream);
        }
    }

    private static Map<String, String> loadConfigurationsFromFile(ByteArrayInputStream configurationEntry, PlatformStorage platformStorage) throws IOException, SerializeException {
        HashMap<String, String> configurations = new HashMap<String, String>();
        Properties properties = new Properties();
        properties.load(configurationEntry);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            platformStorage.storeKey((String)entry.getKey(), (String)entry.getValue());
        }
        return configurations;
    }
}

