/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Status;
import at.mrdevelopment.esl.core.UpdateStatusListener;
import at.mrdevelopment.esl.persistence.BatchQueryCallback;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.UpdateStatusDataset;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.esl.persistence.transaction.TaskUpdateTransaction;
import at.mrdevelopment.esl.server.UpdateStatusUpdater;
import at.mrdevelopment.esl.server.WaitingTaskLock;
import at.mrdevelopment.esl.server.WaitingTaskUpdateStatusCache;
import at.mrdevelopment.esl.update.Update;
import at.mrdevelopment.esl.update.UpdateCollection;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ComputationTimeLogger;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.hibernate.Query;

public class WaitingTaskCache
implements UpdateStatusListener {
    static ESLLogger logger = ESLLogger.getLogger(WaitingTaskCache.class);
    private static final int MAX_RESULTS = 10000;
    private final UpdateStatusDataset dataset;
    private final WaitingTaskLock waitingTaskLock;
    private final SortedMap<LabelId, SortedSet<Update>> waitingAndDelayedTaskQueues = new TreeMap<LabelId, SortedSet<Update>>();
    private final Map<UUID, Update> waitingAndDelayedTasks = new HashMap<UUID, Update>();
    private final Map<UUID, Update> unassignedWaitingTasks = new HashMap<UUID, Update>();
    private final Map<UUID, Update> assignedWaitingTasks = new HashMap<UUID, Update>();

    public WaitingTaskCache(UpdateStatusDataset dataset, AccessPointInfoDataset accessPointInfoDataset) throws DatasetException {
        this.dataset = dataset;
        this.waitingTaskLock = new WaitingTaskLock();
    }

    public void init(UpdateStatusUpdater updateStatusUpdater, Transaction<?> transaction) throws DatasetException {
        WaitingTaskUpdateStatusCache cache = new WaitingTaskUpdateStatusCache();
        updateStatusUpdater.registerUpdateStatusListener(cache);
        this.restoreFromDatabase(cache, updateStatusUpdater, transaction);
        updateStatusUpdater.unregisterUpdateStatusListener(cache);
    }

    @Override
    public synchronized void updateStatusAdded(Update update, Transaction<?> transaction) throws DatasetException {
        this.updateChanged(update, transaction);
    }

    @Override
    public synchronized void updateStatusChanged(Update update, Transaction<?> transaction) throws DatasetException {
        this.updateChanged(update, transaction);
    }

    @Override
    public synchronized void updateStatusRemoved(Update update, Transaction<?> transaction) {
    }

    public synchronized List<Update> getWaitingAndDelayedTasksSorted() {
        ArrayList<Update> sortedList = new ArrayList<Update>();
        for (Map.Entry<LabelId, SortedSet<Update>> entry : this.waitingAndDelayedTaskQueues.entrySet()) {
            SortedSet<Update> tasks = entry.getValue();
            sortedList.addAll(tasks);
        }
        return Collections.unmodifiableList(sortedList);
    }

    public synchronized Collection<Update> getWaitingAndDelayedTasksForLabel(LabelId labelId) {
        SortedSet tasksForLabel = (SortedSet)this.waitingAndDelayedTaskQueues.get(labelId);
        if (tasksForLabel == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList(tasksForLabel));
    }

    public synchronized int getWaitingAndDelayedTasksCount() {
        return this.waitingAndDelayedTasks.size();
    }

    public synchronized Update getWaitingOrDelayedTask(UUID taskId) {
        return this.waitingAndDelayedTasks.get(taskId);
    }

    public synchronized Collection<Update> getWaitingAndDelayedUpdatesForTransaction(final long transactionId) {
        return Collections.unmodifiableList(new ArrayList(Collections2.filter(new ArrayList<Update>(this.waitingAndDelayedTasks.values()), (Predicate)new Predicate<Update>(){

            public boolean apply(Update update) {
                return update.getTaskRecord().getTransactionId() == transactionId;
            }
        })));
    }

    public synchronized Collection<Update> getUnassignedTasks() {
        return Collections.unmodifiableList(new ArrayList<Update>(this.unassignedWaitingTasks.values()));
    }

    public synchronized Collection<Update> getAssignedTasks() {
        return Collections.unmodifiableList(new ArrayList<Update>(this.assignedWaitingTasks.values()));
    }

    public synchronized Collection<LabelId> getLabelsWithWaitingOrDelayedTasks() {
        ArrayList<LabelId> labels = new ArrayList<LabelId>(this.waitingAndDelayedTaskQueues.size());
        for (Map.Entry<LabelId, SortedSet<Update>> entry : this.waitingAndDelayedTaskQueues.entrySet()) {
            LabelId labelId = entry.getKey();
            SortedSet<Update> queue = entry.getValue();
            if (queue.isEmpty()) continue;
            labels.add(labelId);
        }
        return Collections.unmodifiableList(labels);
    }

    public synchronized Update getAssignedWaitingTask(UUID taskId) {
        return this.assignedWaitingTasks.get(taskId);
    }

    public synchronized int getAssignedWaitingTaskCount() {
        return this.assignedWaitingTasks.size();
    }

    public void waitForTasks(int maxWaitingTimeInSeconds) throws InterruptedException {
        this.waitingTaskLock.waitForTasks(maxWaitingTimeInSeconds);
    }

    synchronized void updateInternalDatastructures(Update update) {
        logger.info("Updating internal datastructures for task %s in status %s assigned=%b", new Object[]{update.getTaskId(), update.getStatus(), update.isAssigned()});
        UUID taskId = update.getTaskId();
        if (update.isDelayed()) {
            if (this.waitingAndDelayedTasks.put(taskId, update) == null) {
                this.addToWaitingAndDelayedTaskQueue(update);
            }
            this.unassignedWaitingTasks.remove(taskId);
            this.assignedWaitingTasks.remove(taskId);
        } else if (update.isWaiting()) {
            if (this.waitingAndDelayedTasks.put(taskId, update) == null) {
                this.addToWaitingAndDelayedTaskQueue(update);
            }
            if (update.isAssigned()) {
                this.unassignedWaitingTasks.remove(taskId);
                this.assignedWaitingTasks.put(taskId, update);
            } else {
                this.unassignedWaitingTasks.put(taskId, update);
                this.assignedWaitingTasks.remove(taskId);
            }
        } else {
            this.removeFromWaitingAndDelayedTaskQueue(update);
            this.waitingAndDelayedTasks.remove(taskId);
            this.unassignedWaitingTasks.remove(taskId);
            this.assignedWaitingTasks.remove(taskId);
        }
    }

    private void addToWaitingAndDelayedTaskQueue(Update update) {
        LabelId labelId = update.getLabelId();
        TreeSet<Update> waitingAndDelayedTasksForLabel = (TreeSet<Update>)this.waitingAndDelayedTaskQueues.get(labelId);
        if (waitingAndDelayedTasksForLabel == null) {
            waitingAndDelayedTasksForLabel = new TreeSet<Update>(new Comparator<Update>(){

                @Override
                public int compare(Update left, Update right) {
                    return left.getTaskRecord().getId().compareTo(right.getTaskRecord().getId());
                }
            });
            this.waitingAndDelayedTaskQueues.put(labelId, waitingAndDelayedTasksForLabel);
        }
        waitingAndDelayedTasksForLabel.add(update);
    }

    private void removeFromWaitingAndDelayedTaskQueue(Update update) {
        LabelId labelId = update.getLabelId();
        SortedSet queue = (SortedSet)this.waitingAndDelayedTaskQueues.get(labelId);
        if (queue != null) {
            queue.remove(update);
            if (queue.isEmpty()) {
                this.waitingAndDelayedTaskQueues.remove(labelId);
            }
        }
    }

    private void handleUpdate(Update update, boolean storeUpdate, Transaction<?> transaction) throws DatasetException {
        logger.debug("WaitingTasksCache.updateStatusModified: %s / %s / %s / %s", new Object[]{update.getLabelIdString(), update.getStatus(), update.getTaskId(), update.isAssigned() ? Integer.toString(update.getAccessPointId()) : "unassigned"});
        UpdateStatus updateStatus = update.getUpdateStatus();
        try {
            if (storeUpdate) {
                this.dataset.store((Collection<UpdateStatus>)Collections.singleton(updateStatus), UserId.SYSTEM, transaction);
            }
            if (!(transaction instanceof TaskUpdateTransaction)) {
                this.updateInternalDatastructures(update);
            }
        }
        catch (DatasetException exc) {
            UUID taskId = update.getTaskId();
            LabelId labelId = update.getLabelId();
            logger.error("Failed to persist update status of task %s for label %s", new Object[]{taskId, labelId});
            logger.logException((Throwable)exc);
            throw exc;
        }
    }

    private void restoreFromDatabase(WaitingTaskUpdateStatusCache updateStatusUpdateCache, final UpdateStatusUpdater updateStatusUpdater, final Transaction<?> transaction) throws DatasetException {
        logger.info("Rebuilding waiting tasks cache");
        ComputationTimeLogger timeLogger = new ComputationTimeLogger(logger).start();
        ORMTransaction ormTransaction = (ORMTransaction)transaction;
        Query query = ormTransaction.createQuery("select u from UpdateStatus u left join fetch u.taskRecord t left join fetch t.transaction tr left join fetch t.updateImage where u.internal = false and u.status in " + Status.UNFINISHED_SQL);
        ormTransaction.batchQuery(query, 10000, new BatchQueryCallback<UpdateStatus>(){

            @Override
            public void recordsQueried(List<UpdateStatus> records) throws DatasetException {
                logger.info("Handling collection of %d unfinished updates", new Object[]{records.size()});
                WaitingTaskCache.this.restoreUnfinishedUpdates(records, updateStatusUpdater, transaction);
            }
        });
        for (Update update : updateStatusUpdateCache.getUpdates()) {
            this.handleUpdate(update, true, transaction);
        }
        timeLogger.logTimeInfo("Time for rebuilding waiting tasks cache");
        logger.info("Restored waiting and delayed tasks for %d labels", new Object[]{this.waitingAndDelayedTaskQueues.size()});
        logger.info("Restored %d unassigned tasks", new Object[]{this.unassignedWaitingTasks.size()});
        logger.info("Restored %d assigned tasks", new Object[]{this.assignedWaitingTasks.size()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreUnfinishedUpdates(Collection<UpdateStatus> updates, UpdateStatusUpdater updateStatusUpdater, Transaction<?> transaction) throws DatasetException {
        try {
            UpdateCollection updateCollection = new UpdateCollection(updates);
            for (Update update : updateCollection) {
                if (update.getTaskRecord() == null) continue;
                if (update.isInternal() && (update.isWaiting() || update.isDelayed())) {
                    this.dataset.delete((Commitable)update.getUpdateStatus(), UserId.SYSTEM, transaction);
                } else {
                    this.handleUpdate(update, false, null);
                }
                if (update.isReplaceRequested()) {
                    updateStatusUpdater.replace(update, transaction);
                    continue;
                }
                if (!update.isAbortRequested()) continue;
                updateStatusUpdater.cancel(update, transaction);
            }
        }
        finally {
            this.signalTasksWaiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChanged(Update update, Transaction<?> transaction) throws DatasetException {
        try {
            this.handleUpdate(update, true, transaction);
        }
        finally {
            if (!(transaction instanceof TaskUpdateTransaction)) {
                this.signalTasksWaiting();
            }
        }
    }

    private void signalTasksWaiting() {
        boolean hasWaitingOrDelayedTasks = !this.waitingAndDelayedTasks.isEmpty();
        this.waitingTaskLock.signalTasksWaiting(hasWaitingOrDelayedTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStructures(Collection<UpdateStatus> updates) {
        try {
            for (UpdateStatus updateStatus : updates) {
                this.updateInternalDatastructures(new Update(updateStatus));
            }
        }
        finally {
            this.signalTasksWaiting();
        }
    }
}

