/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.configuration.ConfigurationStorage;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.core.problem.ProblemStatus;
import at.mrdevelopment.esl.custom.ConnectorInformationProvider;
import at.mrdevelopment.esl.custom.level1.Level1Connector;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.custom.level2.Level2Connector;
import at.mrdevelopment.esl.custom.level3.Level3Connector;
import at.mrdevelopment.esl.licencing.FeatureUnlock;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.ConfigurationDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseMetaDataWrapper;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseSizeStatistics;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseSizeStatisticsChangedListener;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.ScheduledTaskCountQuery;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.esl.persistence.record.Configuration;
import at.mrdevelopment.esl.server.AbstractServiceStatusDataProvider;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.appliance.disk.DiskState;
import at.mrdevelopment.toolkit.appliance.disk.SMARTAttribute;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.file.FileUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.problem.MessageProblem;
import at.mrdevelopment.toolkit.problem.Problem;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.imagotag.rendering.ImageRenderingEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public class ServiceStatusGenerator
implements DatabaseSizeStatisticsChangedListener {
    static ESLLogger logger = ESLLogger.getLogger(ServiceStatusGenerator.class);
    private final Collection<ProblemStatus> queryProblems = new ArrayList<ProblemStatus>();
    private final Map<Class<? extends Commitable>, List<String>> registeredRecordClasses = new HashMap<Class<? extends Commitable>, List<String>>();
    private final FeatureUnlock featureUnlock;
    private final AbstractServiceStatusDataProvider provider;
    private final UUID databaseIdentifier;
    private final ImageRenderingEngine imageRenderingEngine;
    private final ConnectorInformationProvider connectorInformationProvider;
    private final Level1Interface level1;
    private final ConfigurationDataset configurationDataset;
    private volatile ServiceStatus serviceStatus;

    public ServiceStatusGenerator(Level1Interface level1, ConnectorInformationProvider connectorInformationProvider, AbstractServiceStatusDataProvider provider, Version version, FeatureUnlock featureUnlock, UUID databaseIdentifier, ConfigurationStorage configurationStorage, ImageRenderingEngine imageRenderingEngine, ConfigurationDataset configurationDataset) throws InitializationException, DatasetException {
        this.level1 = level1;
        this.connectorInformationProvider = connectorInformationProvider;
        this.provider = provider;
        this.featureUnlock = featureUnlock;
        this.databaseIdentifier = databaseIdentifier;
        this.imageRenderingEngine = imageRenderingEngine;
        this.configurationDataset = configurationDataset;
        this.serviceStatus = new ServiceStatus("SES-imagotag Core Service");
        provider.initServiceStatus(this.serviceStatus, version);
    }

    public <T extends Commitable> void registerProblemStatus(ProblemStatus problemStatus) {
        this.queryProblems.add(problemStatus);
    }

    public void registerRecordClass(Class<? extends Commitable> recordClass, List<String> customFields) {
        this.registeredRecordClasses.put(recordClass, customFields);
    }

    public synchronized void updateServiceStatus(Transaction<?> transaction) throws DatasetException {
        ServiceStatus newServiceStatus = new ServiceStatus(this.serviceStatus, false);
        this.initializeConnectorInformation(newServiceStatus);
        newServiceStatus.setProperty("database-id", this.databaseIdentifier.toString());
        Configuration configuration = this.configurationDataset.getConfiguration("pluginAgentEnabled", transaction);
        if (configuration != null) {
            newServiceStatus.setProperty("provisioning-enabled", configuration.getValue());
        }
        for (ProblemStatus problemStatus : this.queryProblems) {
            this.updateProblem(problemStatus, newServiceStatus, transaction);
        }
        if (Strings.isNullOrEmpty((String)Config.getEncryptionPassphrase())) {
            newServiceStatus.addProblem((Problem)MessageProblem.createWarning((String)"no-passphrase", (String)"Encryption passphrase unset"));
        }
        if (Config.getPingLabelsIntervalInMinutes() < 30) {
            newServiceStatus.addProblem((Problem)MessageProblem.createWarning((String)"short-ping-interval", (String)"Increased power consumption on labels because ping interval is lower than 30 minutes"));
        }
        if (!this.featureUnlock.isLicensed()) {
            newServiceStatus.addProblem((Problem)MessageProblem.createWarning((String)"unlicensed", (String)"No valid license found"));
        }
        if (!this.featureUnlock.isProductive()) {
            newServiceStatus.addProblem((Problem)MessageProblem.createInfo((String)"non-productive-license", (String)"License not valid for productive environments"));
        }
        newServiceStatus.setProperty("registered-records", this.getRecordClassesString());
        for (Map.Entry entry : this.registeredRecordClasses.entrySet()) {
            Class recordClass = (Class)entry.getKey();
            List customFields = (List)entry.getValue();
            if (customFields.size() <= 0) continue;
            newServiceStatus.setProperty("custom-fields." + recordClass.getSimpleName(), this.getCustomFieldsString(customFields));
        }
        this.provider.updateServiceStatus(newServiceStatus);
        newServiceStatus.setProperty("store-id", Config.getStoreId());
        newServiceStatus.setProperty("system-serial", this.featureUnlock.getDefaultSystemSerial());
        newServiceStatus.setProperty("licensed-mode", this.featureUnlock.getMode().getName());
        newServiceStatus.setProperty("licensed-access-points", (long)this.featureUnlock.getMaxAccessPointsAllowed());
        newServiceStatus.setProperty("licensed-labels", (long)this.featureUnlock.getMaxLabelsAllowed());
        newServiceStatus.setProperty("licensed-customer", this.featureUnlock.getCustomer());
        newServiceStatus.setProperty("licensed-productive", this.featureUnlock.isProductive());
        newServiceStatus.setProperty("rendering-engine-name", this.imageRenderingEngine.getName());
        newServiceStatus.setProperty("rendering-engine-version", this.imageRenderingEngine.getVersion());
        for (Map.Entry entry : this.featureUnlock.getAdditionalServiceStatusEntries().entrySet()) {
            newServiceStatus.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        DatasetQuery scheduledTaskQuery = this.level1.getQuery("scheduledtaskcount");
        List list = scheduledTaskQuery.getResult(QueryRestriction.newUnpagedQuery(), transaction).getRecords();
        if (list.size() == 1) {
            newServiceStatus.setProperty("scheduled-tasks", String.valueOf(((ScheduledTaskCountQuery.IntegerRecord)list.get(0)).getValue()));
        }
        this.removeSuppressedProblems(newServiceStatus);
        this.serviceStatus = newServiceStatus;
    }

    private void initializeConnectorInformation(ServiceStatus newServiceStatus) {
        Collection<Class<? extends Level1Connector>> connectors = this.connectorInformationProvider.getActivatedConnectors();
        HashSet<String> level3Connectors = new HashSet<String>();
        HashSet<String> level2Connectors = new HashSet<String>();
        HashSet<String> level1Connectors = new HashSet<String>();
        for (Class<? extends Level1Connector> connector : connectors) {
            if (connector.getSimpleName().equals("Level1Implementation") || connector.getSimpleName().equals("Level2Implementation") || connector.getSimpleName().equals("Level3Implementation") || connector.getSimpleName().contains("WebserviceLevel") || connector.getSimpleName().contains("ServiceDebugWindow")) continue;
            String name = connector.getSimpleName();
            if (Level3Connector.class.isAssignableFrom(connector)) {
                level3Connectors.add(name);
                continue;
            }
            if (Level2Connector.class.isAssignableFrom(connector)) {
                level2Connectors.add(name);
                continue;
            }
            level1Connectors.add(name);
        }
        newServiceStatus.setProperty("plugins-level1", Joiner.on((String)", ").join(level1Connectors));
        newServiceStatus.setProperty("plugins-level2", Joiner.on((String)", ").join(level2Connectors));
        newServiceStatus.setProperty("plugins-level3", Joiner.on((String)", ").join(level3Connectors));
    }

    private void removeSuppressedProblems(ServiceStatus newServiceStatus) {
        String suppressedProblemsString = Config.getSuppressedProblems() == null ? "" : Config.getSuppressedProblems();
        ArrayList suppressedProblems = Lists.newArrayList((Iterable)Splitter.on((String)";").split((CharSequence)suppressedProblemsString));
        for (String suppressedProblem : suppressedProblems) {
            newServiceStatus.removeProblem(suppressedProblem);
        }
    }

    public synchronized ServiceStatus getServiceStatus(UserId user) {
        ServiceStatus serviceStatusCopy = new ServiceStatus(this.serviceStatus, true);
        serviceStatusCopy.setProperty("user-id", user.getId() != null ? Long.toString(user.getId()) : "");
        serviceStatusCopy.setProperty("username", user.getUsername());
        serviceStatusCopy.setProperty("role", user.getRole().toString());
        return serviceStatusCopy;
    }

    private <T extends Commitable> void updateProblem(ProblemStatus problemStatus, ServiceStatus serviceStatus, Transaction<?> transaction) {
        try {
            problemStatus.update(transaction);
            if (problemStatus.isEnabled()) {
                serviceStatus.addProblem(problemStatus.getProblem());
            }
            if (problemStatus.getPropertyKey() != null) {
                serviceStatus.setProperty(problemStatus.getPropertyKey(), problemStatus.getValue());
            }
        }
        catch (DatasetException exc) {
            logger.error("Failed to update problem %s", new Object[]{problemStatus.getProblem().getIdentifier()});
            logger.logException((Throwable)exc);
        }
    }

    private String getRecordClassesString() {
        TreeSet<String> strings = new TreeSet<String>();
        for (Class<? extends Commitable> recordClass : this.registeredRecordClasses.keySet()) {
            strings.add(recordClass.getSimpleName());
        }
        return StringUtils.join(strings, (String)", ");
    }

    private String getCustomFieldsString(List<String> customFields) {
        return StringUtils.join(customFields, (String)", ");
    }

    @Override
    public synchronized void databaseSizeStatisticsChanged(DatabaseSizeStatistics statistics) {
        if (statistics != null && statistics != DatabaseSizeStatistics.EMPTY) {
            ServiceStatus newServiceStatus = new ServiceStatus(this.serviceStatus, true);
            newServiceStatus.setProperty("db-size-total", FileUtils.toReadableSize((long)statistics.getTotalSizeInBytes()));
            newServiceStatus.setProperty("db-size-used", FileUtils.toReadableSize((long)statistics.getUsedSizeInBytes()));
            newServiceStatus.setProperty("db-size-freeable", FileUtils.toReadableSize((long)statistics.getFreeableSizeInBytes()));
            this.serviceStatus = newServiceStatus;
        }
    }

    public synchronized void updateServiceStatus(DatabaseMetaDataWrapper databaseMetaDataWrapper) {
        ServiceStatus newServiceStatus = new ServiceStatus(this.serviceStatus, true);
        newServiceStatus.setProperty("db-product-name", databaseMetaDataWrapper.getDatabaseProductName());
        newServiceStatus.setProperty("db-product-version", databaseMetaDataWrapper.getDatabaseProductVersion());
        newServiceStatus.setProperty("db-driver-name", databaseMetaDataWrapper.getDriverName());
        newServiceStatus.setProperty("db-driver-version", databaseMetaDataWrapper.getDriverVersion());
        newServiceStatus.setProperty("db-url", databaseMetaDataWrapper.getURL());
        this.serviceStatus = newServiceStatus;
    }

    public synchronized void notifyDiskStateUpdated(DiskState diskState) {
        ServiceStatus newServiceStatus = new ServiceStatus(this.serviceStatus, true);
        newServiceStatus.setProperty(String.format("%s-%s", "smart", "tool-name"), diskState.getToolName());
        newServiceStatus.setProperty(String.format("%s-%s", "smart", "tool-version"), diskState.getToolVersion());
        for (Map.Entry diskInformationEntry : diskState.getDiskInformation().entrySet()) {
            newServiceStatus.setProperty(String.format("%s-%s", "smart", diskInformationEntry.getKey()), (String)diskInformationEntry.getValue());
        }
        for (SMARTAttribute smartAttribute : diskState.getSmartAttributes().values()) {
            newServiceStatus.setProperty(String.format("%s-%s-%s", "smart", smartAttribute.getId(), smartAttribute.getName()), smartAttribute.getValue().longValue());
        }
        this.serviceStatus = newServiceStatus;
    }
}

