/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceManager;
import at.mrdevelopment.esl.roaming.InternalRoamingTable;
import at.mrdevelopment.esl.roaming.RoamingTableBuilder;
import at.mrdevelopment.esl.server.ESLAccessPointProcessingTask;
import at.mrdevelopment.esl.wireless.RoamingTable;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;

public class SendRoamingTableTask
extends ESLAccessPointProcessingTask {
    static ESLLogger logger = ESLLogger.getLogger(SendRoamingTableTask.class);
    private final RoamingTableBuilder roamingTableBuilder;
    private boolean sendRoamingTable = true;

    public SendRoamingTableTask(AccessPointServiceManager accessPointServiceManager, RoamingTableBuilder roamingTableBuilder) {
        super("Send Roaming Table", accessPointServiceManager);
        this.roamingTableBuilder = roamingTableBuilder;
    }

    @Override
    public void runBefore() {
        if (this.roamingTableBuilder.isModified()) {
            this.roamingTableBuilder.printRoamingTable();
            this.sendRoamingTable = true;
        }
    }

    @Override
    public void runForAccessPoint(AccessPointService accessPointService) throws WebserviceException, SerializeException {
        if (this.sendRoamingTable) {
            boolean useThinRoamingTable;
            boolean bl = useThinRoamingTable = this.roamingTableBuilder.isThinRoamingTableSupported() && accessPointService.getProtocol().thinRoamingTableHandling();
            if (useThinRoamingTable) {
                logger.info("Sending roaming table to access point %d", new Object[]{accessPointService.getAccessPointId()});
                accessPointService.sendInternalRoamingTable((InternalRoamingTable)this.roamingTableBuilder.getThinInternalRoamingTable(accessPointService.getAccessPointId()));
            } else {
                RoamingTable roamingTable = this.roamingTableBuilder.getRoamingTable(accessPointService.getAccessPointId());
                logger.info("Sending roaming table with %d entries to access point %d", new Object[]{roamingTable.getSize(), accessPointService.getAccessPointId()});
                accessPointService.sendRoamingTable(roamingTable);
            }
        }
    }

    @Override
    public void runAfterwards() {
        if (this.sendRoamingTable) {
            this.roamingTableBuilder.resetModified();
            this.sendRoamingTable = false;
        }
    }
}

