/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.type.TaskQueueEntry;
import at.mrdevelopment.toolkit.collection.FIFOEntry;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;

public class ScheduledTasksBlockingQueue {
    private final BlockingQueue<FIFOEntry<TaskQueueEntry>> queue = new PriorityBlockingQueue<FIFOEntry<TaskQueueEntry>>();

    public Collection<TaskQueueEntry> take() throws InterruptedException {
        LinkedList<FIFOEntry<TaskQueueEntry>> entryList = new LinkedList<FIFOEntry<TaskQueueEntry>>();
        FIFOEntry<TaskQueueEntry> entry = this.queue.take();
        this.queue.drainTo(entryList);
        entryList.addFirst(entry);
        return Collections2.transform(entryList, (Function)new Function<FIFOEntry<TaskQueueEntry>, TaskQueueEntry>(){

            public TaskQueueEntry apply(FIFOEntry<TaskQueueEntry> entry) {
                return (TaskQueueEntry)entry.getEntry();
            }
        });
    }

    public boolean offer(TaskQueueEntry entry) {
        if (entry == null) {
            throw new NullPointerException();
        }
        return this.queue.offer((FIFOEntry<TaskQueueEntry>)new FIFOEntry((Comparable)entry));
    }

    public int size() {
        return this.queue.size();
    }
}

