/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.toolkit.ClassLoaderBuilder;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PluginLoader {
    static ESLLogger logger = ESLLogger.getLogger(PluginLoader.class);
    private final List<File> pluginDirectories = new ArrayList<File>();
    private final List<File> connectorConfigurationFiles = new ArrayList<File>();
    private final List<File> recordConfigurationFiles = new ArrayList<File>();
    private final List<File> datasetConfigurationFiles = new ArrayList<File>();
    private final List<File> additionalJarLocations = new ArrayList<File>();
    private final ClassLoader classLoader;
    private File renderingEngineFile;

    public PluginLoader(String[] jarLocations, String[] pluginPaths, String systemEnvironmentVariable, String ... additionalPaths) throws InitializationException {
        for (String pluginPath : pluginPaths) {
            for (File plugin : new File(pluginPath).listFiles()) {
                this.addPluginDirectory(plugin);
            }
        }
        String pluginPathEnvironment = System.getenv(systemEnvironmentVariable);
        if (pluginPathEnvironment != null) {
            for (String plugin : StringUtils.split((String)pluginPathEnvironment, (String)";")) {
                this.addPluginDirectory(new File(plugin));
            }
        }
        for (String plugin : additionalPaths) {
            this.addPluginDirectory(new File(plugin));
        }
        this.additionalJarLocations.addAll(Collections2.transform(Arrays.asList(jarLocations), (Function)new Function<String, File>(){

            public File apply(String filename) {
                return new File(filename);
            }
        }));
        this.classLoader = this.newClassLoader();
    }

    public List<File> getConnectorConfigurationFiles() {
        return Collections.unmodifiableList(this.connectorConfigurationFiles);
    }

    public List<File> getRecordsConfigurationFiles() {
        return Collections.unmodifiableList(this.recordConfigurationFiles);
    }

    public List<File> getDatasetsConfigurationFiles() {
        return Collections.unmodifiableList(this.datasetConfigurationFiles);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void addPluginDirectory(File directory) {
        logger.info("Loading plugins from %s", new Object[]{directory.getPath()});
        if (directory.exists() && directory.isDirectory()) {
            File connectorConfigurationFile = new File(directory, "connectors.config");
            File renderingEngineConfigurationFile = new File(directory, "engine.config");
            File recordsConfigurationFile = new File(directory, "records.config");
            File datasetsConfigurationFile = new File(directory, "datasets.config");
            boolean configFound = false;
            if (connectorConfigurationFile.exists() && connectorConfigurationFile.isFile()) {
                this.pluginDirectories.add(directory);
                this.connectorConfigurationFiles.add(connectorConfigurationFile);
                configFound = true;
            }
            if (renderingEngineConfigurationFile.exists() && renderingEngineConfigurationFile.isFile()) {
                this.pluginDirectories.add(directory);
                this.renderingEngineFile = renderingEngineConfigurationFile;
                configFound = true;
            }
            if (recordsConfigurationFile.exists() && recordsConfigurationFile.isFile()) {
                this.pluginDirectories.add(directory);
                this.recordConfigurationFiles.add(recordsConfigurationFile);
                configFound = true;
            }
            if (datasetsConfigurationFile.exists() && datasetsConfigurationFile.isFile()) {
                this.pluginDirectories.add(directory);
                this.datasetConfigurationFiles.add(datasetsConfigurationFile);
                configFound = true;
            }
            if (!configFound) {
                logger.warn("Missing 'connectors.config' or 'engine.config' in plugin directory '%s'", new Object[]{directory.getPath()});
            }
        } else {
            logger.warn("Plugin directory '%s' not found", new Object[]{directory.getPath()});
        }
    }

    private ClassLoader newClassLoader() throws InitializationException {
        ClassLoaderBuilder builder = new ClassLoaderBuilder();
        for (File additionalJarLocation : this.additionalJarLocations) {
            builder.addToClassPath(builder.getJarsInDirectory(additionalJarLocation));
        }
        for (File pluginDirectory : this.pluginDirectories) {
            builder.addDirectory(new File(pluginDirectory, "bin"));
            builder.addToClassPath(builder.getJarsInDirectory(pluginDirectory));
            builder.addToClassPath(builder.getJarsInDirectory(new File(pluginDirectory, "lib")));
        }
        for (File recordsConfigFile : this.recordConfigurationFiles) {
            File directory = recordsConfigFile.getParentFile();
            try {
                builder.addToClassPath(builder.getJarsInDirectory(directory));
                builder.addDirectory(new File("bin"));
            }
            catch (Throwable exc) {
                throw new InitializationException(exc);
            }
        }
        return builder.getClassLoader();
    }

    public boolean hasRenderingEnginePlugin() {
        return this.renderingEngineFile != null;
    }

    public File getRenderingEngineFile() {
        return this.renderingEngineFile;
    }
}

