/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.LabelActivePageDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelPageContentDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.esl.persistence.record.LabelActivePage;
import at.mrdevelopment.esl.persistence.record.LabelPageContent;
import at.mrdevelopment.esl.persistence.record.UpdateImage;
import at.mrdevelopment.esl.persistence.record.User;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.update.Update;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;

public class LabelPageContentStorage {
    static ESLLogger logger = ESLLogger.getLogger(LabelPageContentStorage.class);
    private final LabelInfoDataset labelInfoDataset;
    private final LabelPageContentDataset labelPageContentDataset;
    private final LabelActivePageDataset labelActivePageDataset;

    public LabelPageContentStorage(LabelInfoDataset labelInfoDataset, LabelPageContentDataset labelPageContentDataset, LabelActivePageDataset labelActivePageDataset) {
        this.labelInfoDataset = labelInfoDataset;
        this.labelPageContentDataset = labelPageContentDataset;
        this.labelActivePageDataset = labelActivePageDataset;
    }

    public void updateFinished(Update update, Transaction<?> transaction) {
        try {
            this.updateLabelPageContentAndLabelActivePage(update, transaction);
        }
        catch (DatasetException exc) {
            logger.logException((Throwable)exc);
        }
    }

    private void updateLabelPageContentAndLabelActivePage(Update update, Transaction<?> transaction) throws DatasetException {
        if (update.isSuccessful()) {
            if (this.isSwitchBackTask(update)) {
                this.resetPageContent(update, transaction);
            } else {
                this.updateLabelPageContent(update, transaction);
                this.updateLabelActivePage(update, transaction);
            }
            if (update.hasImage() && update.getTaskType() == TaskType.IMAGE) {
                this.labelInfoDataset.setLastShownImage(update.getLabelId(), update.getUpdateImage());
            } else if (update.getTaskType() == TaskType.SWITCH_PAGE) {
                LabelPageContent record = this.labelPageContentDataset.queryByLabelAndPage(update.getLabelId(), update.getPage(), transaction);
                UpdateImage lastShownImage = record != null ? record.getUpdateImage() : null;
                this.labelInfoDataset.setLastShownImage(update.getLabelId(), lastShownImage);
            }
        } else if (update.isAborted()) {
            this.resetPageContent(update, transaction);
        } else if (update.isUnsuccessful()) {
            this.resetPageContent(update, transaction);
        }
    }

    private boolean isSwitchBackTask(Update update) {
        if (update.getTaskType() == TaskType.SWITCH_PAGE) {
            String data = update.getTaskRecord().getData();
            Integer duration = 0;
            try {
                if (data != null) {
                    duration = Integer.valueOf(data);
                }
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
            return duration > 0;
        }
        return false;
    }

    private void resetPageContent(Update update, Transaction<?> transaction) throws DatasetException {
        LabelActivePage labelActivePage;
        if (this.isUpdateRelevantForActivePage(update) && (labelActivePage = this.labelActivePageDataset.queryByLabel(update.getLabelId(), transaction)) != null) {
            this.labelActivePageDataset.delete((Commitable)labelActivePage, User.SYSTEM, transaction);
        }
        if (this.isUpdateRelevantForPageContent(update)) {
            this.labelPageContentDataset.deleteByLabelAndPage(update.getLabelId(), update.getPage(), transaction);
        }
    }

    private boolean isUpdateRelevantForActivePage(Update update) {
        return update.getTaskType() == TaskType.IMAGE || update.getTaskType() == TaskType.SWITCH_PAGE;
    }

    private boolean isUpdateRelevantForPageContent(Update update) {
        return update.hasImage() && (update.getTaskType() == TaskType.IMAGE || update.getTaskType() == TaskType.PRELOAD_IMAGE);
    }

    private void updateLabelActivePage(Update update, Transaction<?> transaction) throws DatasetException {
        if (update.isSuccessful() && this.isUpdateRelevantForActivePage(update)) {
            LabelActivePage labelActivePage = this.labelActivePageDataset.queryByLabel(update.getLabelId(), transaction);
            if (labelActivePage == null) {
                labelActivePage = new LabelActivePage(update.getLabelId(), update.getPage());
            }
            labelActivePage.setPage(Integer.valueOf(update.getPage().getPageIndex()));
            this.labelActivePageDataset.store((Commitable)labelActivePage, UserId.SYSTEM, transaction);
        }
    }

    private void updateLabelPageContent(Update update, Transaction<?> transaction) throws DatasetException {
        if (update.isSuccessful() && this.isUpdateRelevantForPageContent(update)) {
            LabelPageContent labelPageContent = this.labelPageContentDataset.queryByLabelAndPage(update.getLabelId(), update.getPage(), transaction);
            if (labelPageContent == null) {
                labelPageContent = new LabelPageContent(update.getLabelId(), update.getPage(), update.getUpdateImage());
            }
            labelPageContent.setUpdateImage(update.getUpdateImage());
            this.labelPageContentDataset.store((Commitable)labelPageContent, User.SYSTEM, transaction);
        }
    }
}

