/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.core.LabelDetailListener;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.LabelDetailDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.LabelDetail;
import at.mrdevelopment.esl.update.Update;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Collection;

public class LabelDetailCache
implements LabelDetailListener {
    static ESLLogger logger = ESLLogger.getLogger(LabelDetailCache.class);
    private final LabelDetailDataset dataset;

    public LabelDetailCache(LabelDetailDataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public void newLabelDetail(Update update, Collection<LabelDetail> labelDetails, Transaction<?> transaction) {
        if (update.isSuccessful()) {
            try {
                this.dataset.store(labelDetails, UserId.SYSTEM, transaction);
            }
            catch (DatasetException exc) {
                LabelId labelId = update.getLabelId();
                logger.error("Failed to persist label detail for label %s", new Object[]{labelId});
                logger.logException((Throwable)exc);
            }
        }
    }
}

